<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Inbox extends CI_Controller {

    /**
     * Inbox Controller
     *
     */
    function __construct() {
        parent::__construct();
		session_set_cookie_params(0,'/inbox',DIRECT_DOMAIN,TRUE,TRUE);
        session_cache_limiter('none'); //fix to get IE to download files
        session_start();
        date_default_timezone_set(ENVIRONMENT_TIMEZONE);
        
        //if user is not authenticated, redirect to auth page, otherwise proceed to load controller
        if($this->session->userdata("is_loggedin") != "true") { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }
		
		//prev last activity update set to current last activity so we can reset it for functions we don't want to consider "activity"
		if(strlen($this->session->userdata('app_last_activity')) > 0) { $this->session->set_userdata('prev_last_activity',$this->session->userdata('app_last_activity')); }
		//if last activity not yet set, set it to current time
		else { $this->session->set_userdata('app_last_activity',time()); }
		
        //check if it the user needs to be logged out due to inactivity
        if(abs($this->session->userdata('app_last_activity') - time()) > (SESSION_TIMEOUT_MINS*60)) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }    
        //update the last activity for the timeout
		else { $this->session->set_userdata('app_last_activity',time()); }
		
        //check if user has been removed since last page load
        $this->load->database();
        $user_exists = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
        //only destroy session if query successfully shows that the user no longer exists among active users
        if($user_exists) { if($user_exists->num_rows() < 1 || $user_exists->num_rows() > 1) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); } }
		
		//get group mailbox information
		$ldapconfig["user"] = $this->session->userdata("username");
		$ldapconfig["pwd"] = $this->encrypt->decode($this->session->userdata("ep"));
		$this->load->library("ldap",$ldapconfig);
		$group_mailboxes = $this->ldap->get_group_membership('uid='.$this->session->userdata('username').','.LDAP_ACCOUNTS_DN);
		$this->session->set_userdata('group_mailboxes',$group_mailboxes);
		
		//set the mailbox group no matter what if the user is in a group mailbox and it has not been set
		if(count($group_mailboxes) > 0 && strlen($this->session->userdata('mailbox_group')) <= 0) { $this->session->set_userdata('mailbox_group',$this->session->userdata('username')); }
		//check mailbox group is a group the user is allowed to be in (prevent URL manipulation setting this variable to something else)
		$mailbox_group = $this->session->userdata('mailbox_group');
		if($mailbox_group != $this->session->userdata('username')) {
			$valid_mailbox = FALSE;
			foreach($group_mailboxes as $key => $group) {
				if($mailbox_group == $key) { $valid_mailbox = TRUE; }
			}
			//if not a valid mailbox, force it back to the personal mailbox
			if(!$valid_mailbox) {
				$this->session->set_userdata('mailbox_group',$this->session->userdata('username'));
				$_SESSION['mailbox'] = 'INBOX';
			}
			else {
				if(strlen($this->session->userdata('login_mailbox')) > 0) {
					$_SESSION['mailbox'] = $this->session->userdata('login_mailbox');
				}
			}
		}

		//get timezone information
		$user_timezone = $this->get_user_timezone();
		if($user_timezone) {
			date_default_timezone_set($user_timezone);
		}
    }
    
    /* This is the main function for the inbox. It will get the header data for all messages in the current mailbox
     * which can then be displayed in a table in the inbox/index view.
     */
    public function index()
    {    
		$this->load->model('user_model');
        $display_per_page = INBOX_DISPLAY_PER_PAGE; //configure how many emails to display per page        

        //connect to IMAP
        $this->imap_connect();
        if($this->peeker->connected) {
            $data["connected"] = TRUE;

            //get message count for this mailbox
            $msg_count = $this->peeker->get_message_count(TRUE);            

            //if not currently set, set the page starting with message 1
            if(!isset($_SESSION['page_start'])) { $_SESSION['page_start'] = "1"; }
            $page_start = $_SESSION['page_start'];
    
            //if page start higher or lower than it can go set it back to a valid value
            if($page_start > $msg_count) {
                $page_start = $msg_count - $display_per_page;
                $_SESSION['page_start'] = $page_start;
            }
            
            if($page_start <= 0) {
                $page_start = 1;
                $_SESSION['page_start'] = $page_start;
            }
            
            //if there are at least $display_per_page messages in the inbox, display the selected messages
            if($msg_count >= $display_per_page) {

                //set the end number to display (equal to message count on last page) i.e. 12 total messages, 10 per page, last page says 11-12
                $end_display = (($page_start+($display_per_page-1)) > $msg_count) ? ($msg_count) : ($page_start+($display_per_page-1));

                $page_display = "<span class=\"text\">" . $page_start . "<abbr title=\"to\">-</abbr>" . $end_display . " of " . $msg_count  . "</span>";
                $forward_page = "<a class=\"move_page\" href=\"" . base_url() . "inbox/page/" . ($_SESSION['page_start']+$display_per_page). "\">" . 
								"<span class=\"move_page\"><img src=\"/images/gt.png\" alt=\"Next Page\" height=\"10\" /></span></a>";
                $backward_page = "<a class=\"move_page\" href=\"" . base_url() . "inbox/page/" . ($_SESSION['page_start']-$display_per_page) . "\">" . 
								 "<span class=\"move_page\"><img src=\"/images/lt.png\" alt=\"Previous Page\" height=\"10\" /></span></a>&nbsp;";        
            
                switch($page_start) {
                    case 1: //first page
                        $data["pagination"] =  $page_display . $forward_page;
                        $start = $page_start;
                        $end = ($page_start+$display_per_page)-1;
                        break;
    
                    case (($page_start+$display_per_page) < $msg_count): //neither first nor last page
                        $data["pagination"] = $page_display .  $forward_page . $backward_page;
                        $start = $page_start;
                        $end = ($page_start+$display_per_page)-1;
                        break;
    
                    default: //last page
                        $data["pagination"] = $page_display . $backward_page;
                        $start = $page_start;
                        $end = $msg_count;
                }    
                $headers = $this->peeker->message_headers($start,$end);
            }
            //if there are less than $display_per_page, but more than 0, display all messages
            else if($msg_count > 0) {
                $data["pagination"] = "<span style=\"font-weight: normal; font-size: 14px;\">" . $page_start . "-" . $msg_count . " of " . $msg_count . "</span>";
                $headers = $this->peeker->message_headers("1",$msg_count);
            }
            //if there are no messages, say so
            else {
                $data["pagination"] = "";
                $headers = "There are no messages to display.";
            }
                    
            //set number of unread messages, if there are any
            $unseen_search = imap_search($this->peeker->resource, "UNSEEN");
            $_SESSION['unseen'] = (!empty($unseen_search)) ? count($unseen_search) : 0;

            //set mailbox to display in title
			$mailbox_group = $this->session->userdata('mailbox_group');
			$is_group = false;
			if(isset($_SESSION['mailbox'])) {
				if($this->mailformat->replaceFirst($_SESSION['mailbox'],GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.',"") != $_SESSION['mailbox']) {
					$title_mbox = PORTAL_TITLE_PREFIX . $this->mailformat->replaceFirst($_SESSION['mailbox'],GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.',"") . ' [' . $mailbox_group . ']';
					$is_group = true;
				}
				else { $title_mbox = PORTAL_TITLE_PREFIX . $this->mailformat->replaceFirst($_SESSION['mailbox'],CUSTOM_MAILBOX_PREFIX,"");}
			}
			else { $title_mbox = PORTAL_TITLE_PREFIX . "Inbox"; }
        
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            //set the title of the page
            $data['title'] = ((isset($_SESSION['unseen']) && $_SESSION['unseen'] > 0)) ? ($title_mbox." (".$_SESSION['unseen'].")") : ($title_mbox);
			
			//
			if($is_group){
				$data['current_user'] = $this->user_model->logged_in_user('user_id');
				$data['display_name'] = $this->user_model->user_cn_from_id($data['current_user']);
				$data['other_members'] = $this->get_group_members($mailbox_group);
				$data['status_enabled'] = true;
			}
			else{
				$data['status_enabled'] = false;
			}
			
			//get flag & workflow data and put them in the header object
			$this->load->model('flag_model');
			$this->load->model('public_distribution_list_model','pubdistlist');
			$this->load->model('private_distribution_list_model','privdistlist');
			if($is_group) $this->load->model('workflow_model');
			if(is_array($headers)){
				foreach($headers as $header) {
					if(isset($header->to)){
						foreach($header->to as $rcp){
							if($this->pubdistlist->formatted_like_an_alias($rcp->mailbox)){
								$rcp->personal = $this->pubdistlist->find_one($this->pubdistlist->id_from_alias($rcp->mailbox))['name'];
							}
							else if ($this->privdistlist->formatted_like_an_alias($rcp->mailbox)){
								$rcp->personal = $this->privdistlist->find_one($this->privdistlist->id_from_alias($rcp->mailbox))['name'];
							}
						}
					}
					$message = get_message(trim($header->uid)); //using the message object minimizes the number of times we need to grab the custom flags					
					$flag = $this->flag_model->find_for_message($message);
					if(!empty($flag)){
						$header->flag_info = $flag;
					}
					if(isset($this->workflow_model)){
						$workflow_item = $this->workflow_model->find_for_message($message);
						if(!empty($workflow_item)){
							$header->workflow_info = $workflow_item;
						}
					}
				}
			}
			
            //set headers within data to pass to view
            $data["headers"] = $headers;

            //set mailbox list
            $data["mailboxes"] =  $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);
			
			//give raw list of mailboxes in JSON format to the move menu
			$data['json_mailbox_list'] = $this->json_folder_list(FALSE);
			
			//get last login data
			$get_last_logon = $this->db->query('SELECT TOP(2) * FROM logins WHERE username=' . $this->db->escape($this->session->userdata('username')) . ' ORDER BY login_time DESC');
			$row = $get_last_logon->row_array(1);
			if($row["success"] == TRUE) { $success = "successful"; } else { $success = "<span style=\"font-weight: bold;\">unsuccessful</span>"; }
			$data['first_login_message'] = '<div id="logon_notice" class="modal_msg">';
			$data['first_login_message'] .= 'Last login attempt was ' . $success . ' from IP address: ' . $row['ip_address'] . ' at ' . date('m/d/y h:i:s A',$row['login_time']);
			$data['first_login_message'] .= '<a onclick="$(\'.modal_msg\').delay(1000).fadeOut(1000,function() { $(\'.modal_msg\').remove(); });"><img src="/jscripts/fancybox/fancy_close.png" alt="Close Login Message" /></a>';
			$data['first_login_message'] .= '</div>';
			
            //load view
			if(isset($_SESSION['mailbox']) &&  ($_SESSION['mailbox'] === 'Sent Messages' || $_SESSION['mailbox'] === 'Drafts')) {
				$this->load->view('inbox/sent_draft_index',$data);
			}
			else if(isset($_SESSION['mailbox']) && ($_SESSION['mailbox'] === (GROUP_MAILBOX_PREFIX.'.'.$mailbox_group.'.Sent Messages') || $_SESSION['mailbox'] === (GROUP_MAILBOX_PREFIX.'.'.$mailbox_group.'.Drafts'))) {
				$this->load->view('inbox/sent_draft_group_index',$data);
			}
			else {
				$this->load->view('inbox/index',$data);
			}
            $this->peeker->close(); //close IMAP connection
        }
        else {
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
            $data["connected"] = FALSE;
            $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
            $this->load->view('inbox/index',$data);
        }    
    }
    
     /* Provides number of messages in inbox since the index was last accessed. For use with ajax request to see
      * if new messages are waiting.
      */
    public function message_waiting_count() {
		//don't count this as activity
		$this->session->set_userdata('app_last_activity',$this->session->userdata('prev_last_activity'));
        $this->imap_connect();
        $unseen_search = imap_search($this->peeker->resource, "UNSEEN");
        $count = (!empty($unseen_search)) ? count($unseen_search) : 0;
        if(isset($_SESSION['unseen'])) { 
            echo $count - $_SESSION['unseen'];
        }
        else { echo $count; }
        $this->peeker->close();
    }
    
    
    /* This function loads a view to display a single message with the given id.
     */
    public function viewmsg($id) {
        $this->imap_connect(); //connect to IMAP
        if($this->peeker->connected) {
            $data["connected"] = TRUE;
            //get the message with the provided id
            $msg = $this->peeker->get_message($id);
            //format the message parts for display
            $data = $this->mailformat->format_msg_display($msg);
            $data['msg_id'] = $id; //put id in data for later use
            $data['msg_uid'] = imap_uid($this->peeker->resource,$id); //put uid in data for later use
            
            //refresh mailbox list
            $data["mailboxes"] =  $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);
			
			//set message status
			$mailbox_group = $this->session->userdata('mailbox_group');
			$data['status_enabled'] = false;
			if(isset($_SESSION['mailbox'])) {
				if($this->mailformat->replaceFirst($_SESSION['mailbox'],GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.',"") != $_SESSION['mailbox']) {
					$data['current_user'] = $this->user_model->logged_in_user('user_id');
					$data['display_name'] = $this->user_model->user_cn_from_id($data['current_user']);
					$data['other_members'] = $this->get_group_members($mailbox_group);
					$data['status_enabled'] = TRUE;
					//get workflow data
					$this->load->model('workflow_model');
					$message = get_message(trim($data['msg_uid'])); //using the message object minimizes the number of times we need to grab the custom flags
					if(isset($this->workflow_model)){
						$workflow_item = $this->workflow_model->find_for_message($message);
						if(!empty($workflow_item)){
							$data['workflow_info'] = $workflow_item;
						}
					}
				}
			}
			
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            //pass data to the view and load it, or redirect to compose if its a draft
            ($msg->Draft != "X") ? $this->load->view('inbox/detailedmsgview',$data) : redirect('inbox/compose/draft/' . $id);

            $this->peeker->close(); //close IMAP connection
        }
        else {
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
            $data["connected"] = FALSE;
            $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
            $this->load->view('inbox/index',$data);
        }
    }

    /* This function changes the current mailbox by setting the current mailbox in session
     * to the provided input. It is called from links, so it expects a url encoded base64 string,
     * which it will then decode. It redirects back to the index when done.
     */
    function change_mailbox($mailbox) {
        $this->imap_connect(); //connect to IMAP
        if($this->peeker->connected) {
            $data["connected"] = TRUE;
            $_SESSION['mailbox'] = base64_decode(urldecode($mailbox)); //set current mailbox

            //refresh mailbox list
            $data["mailboxes"] =  $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);

            $_SESSION['page_start'] = "1"; //bring user back to first page
	
            $this->peeker->close(); //close IMAP
			redirect("inbox"); //redirect to index
        }
        else {
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
            $data["connected"] = FALSE;
            $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
            $this->load->view('inbox/index',$data);
        }
    }

    /* This function changes the page start session value. The page start session value determines
     * the message id that the index function will start the current page display at.
     * TO DO: Add input validation. Low priority since invalid call will simply not return messages.
     */
    function page($start) {
        $_SESSION['page_start'] = $start;
        redirect("inbox");
    }


    /* This function checks to see which type of form was submitted so that forms with multiple buttons can be handled  
     * differently
     */
    function form_check() {
        $post_array = $this->input->post(NULL,TRUE);
        if(!empty($post_array)) {
            $send = array_key_exists("send",$this->input->post(NULL,TRUE)); //detect send submission
            $save = array_key_exists("save",$this->input->post(NULL,NULL,TRUE)); //detect save submission
            $archive = array_key_exists("archive",$this->input->post(NULL,TRUE)) || array_key_exists('archive_hidden',$this->input->post(NULL,TRUE)) ; //detect archive submission
            $search = array_key_exists("search",$this->input->post(NULL,TRUE)); //detect search submission
            $compose = array_key_exists("compose",$this->input->post(NULL,TRUE)); //detect compose submission
			$create_folder = array_key_exists('create_folder',$this->input->post(NULL,TRUE)); //detect create folder submission
			$mark_as_read = array_key_exists("mark_as_read",$this->input->post(NULL,TRUE)) || array_key_exists('mark_as_read_hidden',$this->input->post(NULL,TRUE)) ; //detect mark as read submission
            $mark_as_unread = array_key_exists("mark_as_unread",$this->input->post(NULL,TRUE)) || array_key_exists('mark_as_unread_hidden',$this->input->post(NULL,TRUE)) ; ; //detect mark as unread submission
			$feedback = array_key_exists("feedback",$this->input->post(NULL,TRUE)); //detect feedback submission
		
			//detect move submission (either from hidden move button or regular one)
            if(array_key_exists('move',$this->input->post(NULL,TRUE))) {
				$move = TRUE; $move_action = 'move';
			}
			else if(array_key_exists('move_hidden',$this->input->post(NULL,TRUE))) {
				$move = TRUE; $move_action = 'move_hidden'; $this->session->set_flashdata('last_button','move_hidden');
			} else { $move = FALSE; }
			
            //detect rename folder submission (submission only happens via button on hidden menu)
			foreach($post_array as $key => $input) {
				if(strpos($key,'rename_folder_') !== FALSE) {
					$folder_name = rawurlencode(base64_encode($this->input->post('old_value_'.str_replace('rename_folder_','',$key),TRUE)));
				}
			}
			
			//based on detections, call appropriate functions
            if($send) { $this->send(); }
            else if($save) { $this->save("draft"); }
            else if($search) { $this->search(); }
            else if($compose) { redirect("inbox/compose"); }
			else if($create_folder) { $this->create_folder(); }
            else if($move) { $this->move($move_action); }
            else if($mark_as_read) { 
				if(array_key_exists('mark_as_read_hidden',$this->input->post(NULL,TRUE))) { $this->session->set_flashdata('last_button','mark_as_read_hidden'); }
				$this->mark_as_read(); 
			}
			else if($mark_as_unread) { 
				if(array_key_exists('mark_as_unread_hidden',$this->input->post(NULL,TRUE))) { $this->session->set_flashdata('last_button','mark_as_unread_hidden'); }
				$this->mark_as_unread(); 
			}
            else if($feedback) { $this->feedback(); }
			else if(isset($folder_name)) { $this->rename_folder($folder_name); redirect('inbox'); }
			
			//for archive perform some additional actions
            else if($archive) {
				if(array_key_exists('archive_hidden',$this->input->post(NULL,TRUE))) { $this->session->set_flashdata('last_button','archive_hidden'); }
                $this->imap_connect();
                if($this->peeker->connected) {
                    $data["connected"] = TRUE;
                    foreach($this->input->post(NULL, TRUE) as $key => $value) { //loop through checkboxes to find messages to archive
                        if($value == "on") { 
                            $id = str_replace("select","",$key);
                            $this->archive($id);
                        }
                    }
                    $this->peeker->close();
                    redirect("inbox");
                }
                else {
					//load theme info into view data
					$this->load->model('webmailmodel');
					$get_theme = $this->webmailmodel->get_user_theme_info();
					$data['get_theme'] = $get_theme;
			
                    $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
                    $data["connected"] = FALSE;
                    $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
                    $this->load->view('inbox/index',$data);
                }
            }
            else { show_404(); }
        }
        else { 
            //catch upload size > post_max_size error
            if(empty($_FILES) && empty($_POST) && isset($_SERVER['REQUEST_METHOD']) && strtolower($_SERVER['REQUEST_METHOD']) == 'post'){
                $this->session->set_userdata('message',
                '<script>
					var nth = noty({
						text: \'Failed to send message, attachment size was greater than 10 MB. Failed to save draft since message size was greater than server request limit.\',
						type: \'error\',
						timeout: 5000
					});
                </script>'); 
                redirect('inbox'); 
            }
            else {
                $this->session->set_userdata('message',
                '<script>
					var nth = noty({
						text: \'Form submission failed.\',
						type: \'error\',
						timeout: 5000
					});
                </script>');
                redirect('inbox');
            }
        }
    }
    
    /* This function moves mail to the archive mailbox (created on login if non-existent). If the mail is moved          
     * successfully, it is removed from its original mailbox upon expunge. 
     */
    function archive($uid) {
        $remove_flag = imap_clearflag_full($this->peeker->resource, $uid, '\\Draft',ST_UID);
        if($remove_flag) {
			$mailbox_group = $this->session->userdata('mailbox_group');
			if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata("username")) { 
				$archive_str = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'."Archive"; 
			}
			else { $archive_str = "Archive"; }
			$success = $this->peeker->move_mail($uid,$archive_str,TRUE);
            if($success) { 
				$this->peeker->expunge(); 
				$this->session->set_flashdata('message_class','success');
				$this->session->set_flashdata('message','Message successfully archived.');
				return true; 
			}
            else { 
				$this->session->set_flashdata('message_class','error');
				$this->session->set_flashdata('message','Failed to archive message.');
				return false; 
			}
        }
        else { 
			$this->session->set_flashdata('message_class','error');
			$this->session->set_flashdata('message','Failed to archive message.');
			return false; 
		}
    }

    /* This function prepares and loads the compose mail view. If given the optional inputs, it will
     * expect "reply" for replies and "fwd" for forward, followed by the message id of the message to be
     * replied to or forwarded. It will use this to populate a quote of the old message, and in the case of
     * replies, populate the to field of the new lmessage from the from field of referenced message.
     */
    function compose($type=NULL,$id=NULL) {
		$this->load->library('mailformat');

        $this->imap_connect();
		$this->clear_attachments(); //clear attachments when visiting compose in case any were not removed from previous messages
		unset($_SESSION['first_autosave_done']);
        if($this->peeker->connected) {
            //set title and connection status
            $data["connected"] = TRUE;
            $data["title"] = "Compose Mail";

            //if this is a reply/forward
            if($id != NULL && $type != NULL) {
				if(!is_numeric($id)) { show_404(); }
                $msg = $this->peeker->get_message($id);
                $msg_parts = $this->mailformat->format_msg_display($msg);
                if($type == "reply" || $type == "fwd" || $type == 'replyall') {
					unset($_SESSION['compose_draft_id']);
                    if($type == "reply") {
                        $to_value = implode("; ", $this->mailformat->format_display_addresses_for_sending($msg_parts['msg_from_array']));
						if(mb_substr($to_value, -1) != ';') { $to_value = $to_value.';'; }
                        $data['to_value'] = $to_value;
						$data['subject_value'] = $this->mailformat->msg_subject_sanitize($msg_parts['msg_subject'],$type);
					}
                    else if($type == "fwd") {
                        $data['to_value'] = "";
                        $data['subject_value'] = $this->mailformat->msg_subject_sanitize($msg_parts['msg_subject'],$type);
                        if(isset($msg_parts['attachment'])) { $data['attachments'] = $msg_parts['attachment']; }
                    }
					else if($type == 'replyall') {
						$mailbox_group = $this->session->userdata('mailbox_group');
						$to_value = implode("; ", $this->mailformat->format_display_addresses_for_sending($msg_parts['msg_from_array']));
						if(mb_substr($to_value, -1) != ';') { $to_value = $to_value.';'; }
                        $data['to_value'] = $to_value;
						
						//get rid of current user's address from to and cc lines so as to not include it in reply all
						$cc_line1_arr = $msg_parts['msg_to_array'];
						$cc_line2_arr = $msg_parts['msg_cc_array'];
						
						//get from addresses, since they will be in the "To" line, so we can remove them from the "CC" line
						$i = 0;
						$from_arr = $msg->get_from_array();
						$to_address_arr = array();
						foreach($from_arr as $from_address) {
							if(isset($from_arr[$i]) && isset($from_arr[$i]->mailbox) && isset($from_arr[$i]->host)) {
								$address_str = $from_arr[$i]->mailbox.'@'.$from_arr[$i]->host;
								array_push($to_address_arr, $address_str);
							}
							$i++;
						}
						//merge the arrays and make the values unique
						$cc_line_arr = array_values(array_unique(array_merge($cc_line1_arr,$cc_line2_arr))); //remove duplicates in CC line, reset indices
						//figure out which address to remove from the cc line (if the user is on a group view it needs to be the group address)
						if(strlen($mailbox_group) > 0) {
							$cur_address = 	$mailbox_group . '@' . DIRECT_DOMAIN;
						}
						else { 
							if(strlen($this->session->userdata('user_mail')) > 0) { $cur_address = $this->session->userdata('user_mail'); }
							else { $cur_address = $this->session->userdata('username') . '@' . DIRECT_DOMAIN; }
						}
						
						$i = 0;
						foreach($cc_line_arr as $address) {
							foreach($to_address_arr as $to_address) {
								if($to_address == $address) { unset($cc_line_arr[$i]); } //remove any address already in the To line from CC line
							}
							if($address == $cur_address) { unset($cc_line_arr[$i]); } //remove current user's address from CC line
							$i++;
						}
						$cc_line_arr = array_values($cc_line_arr); //reset indices after unset operations
						$cc_value = implode("; ", $this->mailformat->format_display_addresses_for_sending($cc_line_arr));
						if(mb_substr($cc_value, -1) != ';') { $cc_value = $cc_value.';'; }
						//only set CC line if there are recipients
						if(strlen(str_replace(';','',$cc_value)) > 0) {
							$data['cc_value'] = $cc_value;
						}
						 
						$data['subject_value'] = $this->mailformat->msg_subject_sanitize($msg_parts['msg_subject'],$type);
					}
                    $data['quote_body'] = "<br />------------------------------------------------------------------<br />\r\n";
                    $data['quote_body'] .= "From: " . implode(", ", $msg_parts['msg_from_array']) . "<br />\r\n";
                    $data['quote_body'] .= "To: " . implode(", ", $msg_parts['msg_to_array']) . "<br />\r\n";
					if(count($msg_parts['msg_cc_array']) > 0) {  $data['quote_body'] .= "CC: " . implode(", ", $msg_parts['msg_cc_array']) . "<br />\r\n"; }
                    $data['quote_body'] .= "Date: " . $msg_parts['msg_date_quote'] . "<br />\r\n";
                    $data['quote_body'] .= "Subject: " . $msg_parts['msg_subject'] . "<br /><br />\r\n\r\n";
                    $data['quote_body'] .= $msg_parts['raw_msg_body'];
                    $data['msg_id'] = $id;
                    $data['type'] = $type;
                }
                else if($type == "draft") {
                    if($msg_parts['draft'] == "true") {
                        $data['quote_body'] = $msg_parts['raw_msg_body'];
						//set to value
                        $to_value = implode("; ", $this->mailformat->format_display_addresses_for_sending($msg_parts['msg_to_array']));
						if(strlen(trim($to_value)) > 0) { if(mb_substr($to_value, -1) != ';') { $to_value = $to_value.';'; } }
						$data['to_value'] = $to_value;
						//set cc value
                        $cc_value = implode("; ", $this->mailformat->format_display_addresses_for_sending($msg_parts['msg_cc_array']));
						if(strlen(trim($cc_value)) > 0) { if(mb_substr($cc_value, -1) != ';') { $cc_value = $cc_value.';'; } }
						$data['cc_value'] = $cc_value;
						//set subject value
                        $data['subject_value'] = $msg_parts['msg_subject'];
						//check if attachments exist, add if necessary
                        if(isset($msg_parts['attachment'])) { $data['attachments'] = $msg_parts['attachment']; }
						//check if priority is set, add if necessary
						if(isset($msg_parts['priority'])) { $data['priority'] = $msg_parts['priority']; }
                        $data['msg_id'] = $id;
						$_SESSION['compose_draft_id'] = imap_uid($this->peeker->resource,$id);
                    }
                    else {
                        redirect("inbox/viewmsg/" . $id);
                    }
                }
				else { show_404(); }
            }
			else if(is_null($type)) { 
				unset($_SESSION['compose_draft_id']);
				$to_line = html_entity_decode($this->input->post('mail',TRUE));
				if(isset($to_line)) {	
					$data['to_value'] = $to_line;
				}
			}
			else { show_404(); }
        
            //if the mailbox list has not yet been set
            $data["mailboxes"] = $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);
			
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
		
            //pass data to the view and load it
            $this->load->view('inbox/compose',$data);
			
            $this->peeker->close();
        }
        else {
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
            $data["connected"] = FALSE;
            $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
            $this->load->view('inbox/index',$data);
        }
    }
	
	/* This function flags a message for review, or removes the flag if it exists already */
	public function save_flag_message(){
		$this->output->enable_profiler(false);
		$this->load->model('flag_model');	
		$uid = $this->input->post('message_uid',TRUE);
		$content = $this->input->post('flag_message_text',TRUE);
		$color = $this->input->post('color-flag',TRUE);
		$id = $this->input->post('flag_id',TRUE);
		
		if(empty($color)){
			$this->flag_model->remove_from_message($uid); //this will not cause an error if the message is not flagged
		}
		else{
			$values = compact('color', 'content');
			if($this->flag_model->formatted_like_an_id($id)){
				$flag = $this->flag_model->update_for_message($uid, $values, $id);
			}
			else {
				$flag = $this->flag_model->set_for_message($uid, $values);
			}
			if(!empty($flag)) {
				$flag['created_by'] = $this->user_model->user_cn_from_id($flag['created_by']);
				$flag['modified_by'] = $this->user_model->user_cn_from_id($flag['modified_by']);
				echo json_encode($flag);
			}
		}
	}
	
    /* This function moves mail from one mailbox to another
     */
	private function move($action) {
		if($action == 'move') { $new_mailbox = rawurldecode(base64_decode($this->input->post('move',TRUE))); }
		else if ($action == 'move_hidden') { $new_mailbox = rawurldecode(base64_decode($this->input->post('move_select',TRUE))); }
		else { redirect('inbox'); }
		
        $this->imap_connect();
        
        foreach($this->input->post(NULL, TRUE) as $key => $value) { 
            if($value == 'on') { 
                $uid = str_replace('select','',$key);
                $success = $this->peeker->move_mail($uid,$new_mailbox,TRUE);
                if($success) { 
					$this->session->set_flashdata('message_class','success');
					$this->session->set_flashdata('message','Message(s) successfully moved.');
					$this->peeker->expunge(); 
				}
				else {
					$this->session->set_flashdata('message_class','error');
					$this->session->set_flashdata('message','Failed to move message(s).');
				}
            }
        }
        $this->peeker->close();
        redirect('inbox');
    }
    
    /* This function marks mail as read
     */
    private function mark_as_read() {
    
        $this->imap_connect();
        
        foreach($this->input->post(NULL, TRUE) as $key => $value) { 
            if($value == "on") { 
                $uid = str_replace("select","",$key);
                $status = imap_setflag_full($this->peeker->resource, $uid, "\\Seen",ST_UID);
            }
        }
        $this->peeker->close();
        redirect("inbox");
    }
    /* This function marks mail as unread
     */
    private function mark_as_unread() {
    
        $this->imap_connect();
        
        foreach($this->input->post(NULL, TRUE) as $key => $value) { 
            if($value == "on") { 
                $uid = str_replace("select","",$key);
                $status = imap_clearflag_full($this->peeker->resource, $uid, "\\Seen",ST_UID);
            }
        }
        $this->peeker->close();
        redirect("inbox");
    }
    /* This function will save a draft/sent copy of a message by appending it to the Drafts/Sent Messages mailbox (created on login if needed).
     * If the mail is successfully moved and the message already existed as a draft, the previous draft will be deleted.
     */
     function save($type, $attachments = NULL, $failed_to_send = FALSE, $failure_reason = NULL, $redirect = TRUE) {
			$mailbox_group = $this->session->userdata('mailbox_group');
            if($type == "draft") { 
				if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata('username')) { $location = GROUP_MAILBOX_PREFIX.'.'.$mailbox_group.'.'.'Drafts'; }
				else { $location = "Drafts"; }
			}
            if($type == "sent") { 
				if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata('username')) { $location = GROUP_MAILBOX_PREFIX.'.'.$mailbox_group.'.'.'Sent Messages'; }
				else { $location = "Sent Messages"; }
			}
			//load libraries and connect to IMAP
            $this->load->library("session");
            $this->imap_connect();
            if($this->peeker->connected) {
            $data["connected"] = TRUE;
                //add attachments, if any exist
                if(is_null($attachments)) {
					if(!isset($_SESSION['first_autosave_done'])) { //if the autosave has been done once, the files are already in the cache
						//reattach forward attachments, if any exist
						$i = 0;
						$id = $this->input->post('reattach_id',TRUE); //get message id of forward
						if(!empty($id)) { $msg = $this->peeker->get_message($id); }
						if(isset($msg)) { $parts_arr = $msg->get_parts_array(); }
						
						if(!isset($_SESSION['temp_filenames'])) { $_SESSION['temp_filenames'] = array(); }
						$temp_filenames = $_SESSION['temp_filenames'];
						
						//reattach files if a forward
						while($this->input->post('reattach_file' . $i, TRUE) != "") {
							foreach($parts_arr as $part) {
								if($part->filename == $this->input->post('reattach_file' . $i, TRUE) && hash('sha256',$part->string) == $this->input->post('reattach_hash' . $i, TRUE)) {
									$filename = $part->filename;
									$temp_name = uniqid($filename.'_');
									$_SESSION['temp_filenames'][$temp_name] = $filename;
									if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username"))) { mkdir($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username")); }
									$file = fopen($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'.$temp_name,"w");
									fwrite($file,$part->string);
									break;
								}
							}
							$i++;			
						}
					}
                    //attach all files in temporary directory
					if(isset($_SESSION['temp_filenames'])) { //can only attach the files to the saved message if the temp files have been registered in the session
						$temp_filenames = $_SESSION['temp_filenames'];
						$dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata('username');
						if(is_dir($dir)) { //if the cache of attachments exists
							if($dh = opendir($dir)) {
								$i = 0;
								while (false !== ($obj = readdir($dh))) {
									if(is_file($dir.'/'.$obj)) { 
										//set filename on attachment to actual filename from temp filename, if it exists, otherwise use actual filename
										if(isset($temp_filenames[$obj])) { 
											$attachments[$i]['filename'] = $temp_filenames[$obj];
											$attachments[$i]['base64'] = chunk_split(base64_encode(file_get_contents($dir.'/'.$obj)));
											$i++;
										}
									}
								}
								$this->clear_attachments(); //clear attachment cache when done
							}
						}
					}
                }
				
                $boundary = "------=".hash('sha256',(uniqid(rand())));
                $mime_attach = array();
                $i = 0;
				
				if(isset($attachments)) {
					foreach($attachments as $attachment) {
						$mime_attach[$i] = ("--$boundary\r\n"
							. "Content-Type: application/octet-stream; filename=\"". $attachment["filename"] . "\"\r\n"
							. "Content-Transfer-Encoding: base64\r\n"
							. "Content-Disposition: attachment; filename=\"". $attachment["filename"] . "\"\r\n"
							. "\r\n" . $attachment["base64"] . "\r\n"
							. "\r\n\r\n\r\n"); 
						$i++;
					}
				}
				//prepare from line info
				if(strlen(trim($this->session->userdata('user_cn'))) > 0) { $displayname = $this->session->userdata('user_cn'); }
				else { $displayname = $this->session->userdata('username'); }
				
				$this->load->model('public_distribution_list_model','pubdistlist');
				$this->load->model('private_distribution_list_model','privdistlist');
				//prepare to line info
				$to_addresses = $this->input->post('message_to',TRUE);
				$to_addresses = str_replace(';',',',$to_addresses);
				$to_addresses = strip_from_end(',', $to_addresses);
				$addresses = explode(',',$to_addresses);
				$to_addresses = "";
				foreach($addresses as $address) {
					if(!empty($address)) {
						if($this->pubdistlist->formatted_like_an_alias($address)){
							$to_addresses .= implode(',',$this->pubdistlist->addresses_for_list($this->pubdistlist->id_from_alias($address))) . ",";
						}
						else if ($this->privdistlist->formatted_like_an_alias($address)){
							$to_addresses .= implode(',',$this->privdistlist->addresses_for_list($this->privdistlist->id_from_alias($address))) . ",";
						}
						else{
							$to_addresses .= $address.",";
						}
					}
				}
				$to_addresses = strip_from_beginning(',',strip_from_end(',', $to_addresses));
				//prepare cc line info
				$cc_addresses = $this->input->post('message_cc',TRUE);
				$cc_addresses = str_replace(';',',',$cc_addresses);
				$cc_addresses = strip_from_end(',', $cc_addresses); //doesn't trigger uninitialized string offset notice 
				$addresses = explode(',',$cc_addresses);
				$cc_addresses = "";
				foreach($addresses as $address){
					if(!empty($address)) {
						if($this->pubdistlist->formatted_like_an_alias($address)){
							$cc_addresses .= implode(',',$this->pubdistlist->addresses_for_list($this->pubdistlist->id_from_alias($address))) . ",";
						}
						else if ($this->privdistlist->formatted_like_an_alias($address)){
							$cc_addresses .= implode(',',$this->privdistlist->addresses_for_list($this->privdistlist->id_from_alias($address))) . ",";
						}
						else{
							$cc_addresses .= $address.",";
						}
					}
				}
				$cc_addresses = strip_from_beginning(',',strip_from_end(',', $cc_addresses));
				
				//check for group membership for sending address
				if($this->session->userdata('mailbox_group') == $this->session->userdata('username')) {
					$msg = "From: " . '"'.$displayname.'"'.'<'.$this->session->userdata("username") .'@'. DIRECT_DOMAIN . ">\r\n"; //personal
				}
				else if(strlen(trim($this->session->userdata('mailbox_group'))) <= 0) {
					$msg = "From: " . '"'.$displayname.'"'.'<'.$this->session->userdata("username") .'@'. DIRECT_DOMAIN . ">\r\n"; //personal
				}
				else {
					$msg = "From: " . '"'.$displayname.'"'.'<'.$this->session->userdata('mailbox_group') .'@'. DIRECT_DOMAIN . ">\r\n"; //group
				}
				
                
                $msg .= "To: " . $to_addresses . "\r\n";

                if(isset($cc_addresses) && strlen(trim($cc_addresses)) > 0) {
                    $msg .= "Cc: " . $cc_addresses . "\r\n";
                }
				
				 //get priority from form, since it needs to  be saved
				$priority_post = $this->input->post('priority',TRUE);
				if($priority_post == "high") { $priority = '1 (High)'; }
				else if($priority_post == "normal") { $priority = '3 (Normal)'; }
				else if($priority_post == "low") { $priority = '5 (Low)'; }
				else { $priority = '3 (Normal)'; }
		
                $msg .= "Subject: " . $this->input->post('message_subject',TRUE) . "\r\n" .
				       'X-Priority: ' . $priority . '\r\n'
                    ."MIME-Version: 1.0\r\n" ."Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n"
                . "\r\n\r\n"
                           . "--$boundary\r\n"
                . "Content-Type: text/html;\r\n\tcharset=\"ISO-8859-1\"\r\n"
                      . "Content-Transfer-Encoding: 8bit \r\n"
                .  "\r\n\r\n" . $this->input->post('message_body',TRUE) . "\r\n";
                foreach($mime_attach as $attach) {
                        $msg .= $attach;
                }
                $msg .= "--$boundary--\r\n\r\n";
                
                $success = FALSE; //assume fail until proven otherwise
                if($type == "sent") { $success = imap_append($this->peeker->resource,"{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}" . $location, $msg,"\\Seen"); }
                if($type == "draft") { $success = imap_append($this->peeker->resource,"{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}" . $location, $msg, "\\Draft"); }
                
				//check for draft save success
				if($success) {
					if($type === 'draft' && $redirect === TRUE) { //redirect true means its not from the autosave
						if($failed_to_send){ //if type is draft and message failed to send, it is from send function failure
							$this->session->set_flashdata('message_class','error');
							$this->session->set_flashdata('message','Message sending failed. '.$failure_reason.' A draft of the message has been saved.');
						}
						else { //if type is draft and failed to send is not set/false then its a regular draft save action
							$this->session->set_flashdata('message_class','success');
							$this->session->set_flashdata('message','Saved draft successfully.');
						}
					}
					if($type === 'sent' && !$failed_to_send && $redirect === TRUE) { //if it sent successfully
						if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata('username')) {
							if($redirect) { $_SESSION['mailbox'] = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'.'INBOX'; }
							$mailbox = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'.'INBOX';
						}
						else { $_SESSION['mailbox'] = 'INBOX'; $mailbox = 'INBOX'; }
						$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}'.$mailbox); 
						if($redirect) { redirect('inbox');  }
					}
					//if this message was already a draft, get rid of the old copy because we will save over it
					$id = element('compose_draft_id', $_SESSION);
					
					//check for group mailbox
					if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata("username")) {
						if($redirect) { $_SESSION['mailbox'] = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'.'Drafts'; }
						$draft_mailbox = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'.'Drafts';
					}
					else { 
						if($redirect) { $_SESSION['mailbox'] = 'Drafts'; }
						$draft_mailbox = 'Drafts';
					}
					$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}'.$draft_mailbox); //change to drafts
					if(!empty($id)) { $this->peeker->delete_and_expunge(imap_msgno($this->peeker->resource,$id)); } //delete old copy
					$latest_draft = imap_num_msg($this->peeker->resource); //get latest draft id
					if ($type == "draft") { if($redirect) { redirect('inbox/compose/draft/'.$latest_draft); } } //redirect to draft
                }
				else {
					$fail_message = $failure_reason . ' Failed to save draft. Reverting to previous draft. ';
					$this->session->set_flashdata('message_class','error');
					$this->session->set_flashdata('message', $fail_message);
					//check for group mailbox
					if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata("username")) {
						$_SESSION['mailbox'] = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'.'Drafts';
						$draft_mailbox = GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'.'Drafts';
					}
					else { 
						$_SESSION['mailbox'] = 'Drafts';
						$draft_mailbox = 'Drafts';
					}
					$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}'.$draft_mailbox); //change to drafts
					if(isset($_SESSION['compose_draft_id'])) {
						$id = $_SESSION['compose_draft_id'];
						$latest_draft = imap_msgno($this->peeker->resource,$id);
						if($redirect) { redirect('inbox/compose/draft/'.$latest_draft); }
					}
					else { redirect('inbox/compose/'); }
				}
        }
        else {
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
            $data["connected"] = FALSE;
            $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
            $this->load->view('inbox/index',$data);
        }
    }
	
    public function ajax_draft_save() {
		//don't count this as activity
		$this->session->set_userdata('app_last_activity',$this->session->userdata('prev_last_activity'));

		$this->imap_connect();		
		
		if(empty($_SESSION['first_autosave_done'])) { //only save reattachments the first time, after that they stay in the cache
			//reattach forward attachments, if any exist
			$i = 0;
			$id = $this->input->post('reattach_id',TRUE); //get message id of forward
			if(!empty($id)) { $msg = $this->peeker->get_message($id); }
			if(isset($msg)) { $parts_arr = $msg->get_parts_array(); }
			
			if(!isset($_SESSION['temp_filenames'])) { $_SESSION['temp_filenames'] = array(); }
			$temp_filenames = $_SESSION['temp_filenames'];
			
			//reattach files if a forward
			while($this->input->post('reattach_file' . $i, TRUE) != "") {
				foreach($parts_arr as $part) {
					if($part->filename == $this->input->post('reattach_file' . $i, TRUE) && hash('sha256',$part->string) == $this->input->post('reattach_hash' . $i, TRUE)) {
						$filename = $part->filename;
						$temp_name = uniqid($filename.'_');
						$_SESSION['temp_filenames'][$temp_name] = $filename;
						if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username"))) { mkdir($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username")); }
						$file = fopen($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'.$temp_name,"w");
						fwrite($file,$part->string);
						break;
					}
				}
				$i++;			
			}
		}
		$_SESSION['first_autosave_done'] = TRUE;
		
		//attach files in cache, if filenames are available (they should be if there are any in there)
		if(isset($_SESSION['temp_filenames'])) { 
			$temp_filenames = $_SESSION['temp_filenames']; 
			$cache_attachments = array();
			$i = 0;
			$dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata('username');
			if(is_dir($dir)) {
				if($dh = opendir($dir)) {
					while (false !== ($obj = readdir($dh))) {
						if(is_file($dir.'/'.$obj)) { 
							$cache_attachments[$i]['base64'] = chunk_split(base64_encode(file_get_contents(($dir .'/'. $obj)))); 
							$cache_attachments[$i]['filename'] = $temp_filenames[$obj];
							$i++;
						}
					}
				}
			}
			$attachments = $cache_attachments;
		}
		else { $attachments = array(); }
		
		//get rid of working draft, as another will be saved if it fails and we want it gone if it succeeds
		if(isset($_SESSION['compose_draft_id']) && is_numeric($_SESSION['compose_draft_id'])) {
			$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}Drafts'); //change to drafts
			$this->peeker->delete_and_expunge(imap_msgno($this->peeker->resource,$_SESSION['compose_draft_id']));
			
			//change back to original mailbox
			if(isset($_SESSION['mailbox'])) {
				$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}' . $_SESSION['mailbox']); 
			}
			else { $this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}INBOX'); }
			unset($_SESSION['compose_draft_id']);
		}
		
		//save the draft
		if(!isset($_SESSION['compose_draft_id'])) { $this->save('draft',$attachments,NULL,NULL,FALSE); }
		
		//reset the id for the draft
		$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}Drafts'); //change to drafts
		$_SESSION['compose_draft_id'] = imap_uid($this->peeker->resource,imap_num_msg($this->peeker->resource));
		//change back to original mailbox
		if(isset($_SESSION['mailbox'])) {
			$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}' . $_SESSION['mailbox']); 
		}
		else { $this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}INBOX'); }		
		
		//finally, assuming the form submit went through the CSRF protection in order to get to this point,
		//give the new CSRF token as JSON output so the javascript can update it on the page
		echo json_encode(array('token'=>$this->security->get_csrf_hash()));
	}
	
    /* This uses imap_search() to search the imap server for messages relating to the search term.
     * This function is currently implemented to check the subject, text, to and from fields only.
     * imap_search() is limited to IMAP2 search parameters (meaning no OR statement), so we have to perfrom
     * a seperate search for each criteria and then combine results.
     */
    function search() {
        $this->load->library("form_validation");
        $this->form_validation->set_rules("search_input","Search Input","xss_clean");
        if($this->form_validation->run() == true) {
            $search_input = $this->input->post("search_input",TRUE);
            if(!isset($search_input) || strlen($search_input) <= 0) { $search_input = "*"; }
            $this->imap_connect();
			$is_group = FALSE;
            if($this->peeker->connected) {
                $data["connected"] = TRUE;
                //TO DO: come up with a better way to do this, if possible
                $subject_results = @imap_search($this->peeker->resource, "SUBJECT \"" . $search_input . "\"");
                $text_results = @imap_search($this->peeker->resource, "TEXT \"" . $search_input . "\"");
                $from_results = @imap_search($this->peeker->resource, "FROM \"" . $search_input . "\"");
                $to_results = @imap_search($this->peeker->resource, "TO \"" . $search_input . "\"");
                if(!$subject_results) { $subject_results = array(); }
                if(!$text_results) { $text_results = array(); }
                if(!$from_results) { $from_results = array(); }
                if(!$to_results) { $to_results = array(); }
                $results = array_unique(array_merge($subject_results,$text_results,$from_results,$to_results));

                //get headers for each result
                $headers = array();
                $i = 0;
				if(isset($_SESSION['mailbox'])) {
					$mailbox_group = $this->session->userdata('mailbox_group');
					if($this->mailformat->replaceFirst($_SESSION['mailbox'],GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.',"") != $_SESSION['mailbox']) {
						$this->load->model('workflow_model'); 
						$data['current_user'] = $this->user_model->logged_in_user('user_id');
						$data['display_name'] = $this->user_model->user_cn_from_id($data['current_user']);
						$data['other_members'] = $this->get_group_members($mailbox_group);
						$data['status_enabled'] = true;
						$is_group = TRUE;
					}
				}
                foreach($results as $id) {
					$this->load->model('flag_model'); 
                    $headers[$i] = $this->peeker->message_headers($id,NULL,FALSE);
					$message = get_message(trim($headers[$i]->uid)); //using the message object minimizes the number of times we need to grab the custom flags 
					$flag = $this->flag_model->find_for_message($message);
					if(!empty($flag)){
						$headers[$i]->flag_info = $flag;
					}
					if(isset($this->workflow_model)){
						$workflow_item = $this->workflow_model->find_for_message($message);
						if(!empty($workflow_item)){
							$headers[$i]->workflow_info = $workflow_item;
						}
					}
					 $i++;
                }
                //load theme info into view data
				$this->load->model('webmailmodel');
				$get_theme = $this->webmailmodel->get_user_theme_info();
				$data['get_theme'] = $get_theme;
			
				$mailbox_str = $is_group ? $this->mailformat->replaceFirst($_SESSION['mailbox'],GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.',"") : $this->peeker->mailbox;
                $data['title'] = PORTAL_TITLE_PREFIX . "Searching " . $mailbox_str . " for " . $this->input->post("search_input",TRUE);
                $data['search_message'] = "Found " . count($results) . " results in " . $mailbox_str . " for \"" . htmlentities($this->input->post("search_input",TRUE)) . "\"";
                
                if(count($headers) > 0) {  $data['headers'] = $headers; }
                else { $data['headers'] = "The search did not yield any results."; }
                
                //set mailbox list
                $data["mailboxes"] =  $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);

                $this->load->view("inbox/index",$data);
                $this->peeker->close();
            }
            else {
				//load theme info into view data
				$this->load->model('webmailmodel');
				$get_theme = $this->webmailmodel->get_user_theme_info();
				$data['get_theme'] = $get_theme;
			
                $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
                $data["connected"] = FALSE;
                $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
                $this->load->view('inbox/index',$data);
            }
        }
    }

    /* This function sends a message, or saves a draft on message sending failure.
     */
    function send() {
		$resource = '/direct/send/format/json';
		$url = WEBSERVICE_URL . $resource;
		
		 //load libraries
        $this->load->library('audit');
        $this->load->library('encrypt');
        $this->load->library('form_validation');
        
        //configure more items
		//check for group membership for sending address
		if($this->session->userdata('mailbox_group') == $this->session->userdata('username')) {
			$email = $this->session->userdata("user_mail"); //address the email will be sent from
		}
		else if(strlen(trim($this->session->userdata('mailbox_group'))) <= 0) {
			$email = $this->session->userdata('username') . '@' . DIRECT_DOMAIN;
		}
		else {
			$email = $this->session->userdata('mailbox_group') . '@' . DIRECT_DOMAIN;
		}
        
        //get priority from form, since it needs to  be included in mail configuration
        $priority_post = $this->input->post('priority',TRUE);
        if($priority_post == "high") { $priority = 1; }
        else if($priority_post == "normal") { $priority = 3; }
        else if($priority_post == "low") { $priority = 5; }
        else { $priority = 3; }
		
        $body = $this->input->post('message_body',FALSE); //set the body up here so we can change it if needed
		
        //reattach reply/forward attachments, if any exist
        $this->imap_connect();
        $i = 0;
        $reattach_filenames = array();
        $id = $this->input->post('reattach_id',TRUE); //get message id of reply/forward
        if(!empty($id)) { $msg = $this->peeker->get_message($id); }
        if(isset($msg)) { $parts_arr = $msg->get_parts_array(); }
		
        $file_types = "";
		if(!isset($_SESSION['temp_filenames'])) { $_SESSION['temp_filenames'] = array(); }
		$temp_filenames = $_SESSION['temp_filenames'];
		
						
		if(!isset($_SESSION['first_autosave_done'])) { //if autosave has placed reattached files in temp directory, don't do it again
			//reattach files if a forward
			while($this->input->post('reattach_file' . $i, TRUE) != "") {
				foreach($parts_arr as $part) {
					if($part->filename == $this->input->post('reattach_file' . $i, TRUE) && hash('sha256',$part->string) == $this->input->post('reattach_hash' . $i, TRUE)) {
						$filename = $part->filename;
						$temp_name = uniqid($filename.'_');
						$temp_filenames[$temp_name] = $filename;
						$file_types .= pathinfo($filename, PATHINFO_EXTENSION) . " "; //get file extension
						$reattach_filenames[$i] = $filename;
						if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username"))) { mkdir($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username")); }
						$file = fopen($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'.$temp_name,"w");
						fwrite($file,$part->string);
						$body = str_replace($part->cid,$filename,$body); //replace the cid if its an inline attachment
						break;
					}
				}
				$i++;			
			}
		}
		
		//generate temp_attachment array
		 $dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username");
		$temp_attach = array();
		$i = 0;
		if(is_dir($dir)) { 
			if($dh = opendir($dir)) {
				while (false !== ($obj = readdir($dh))) {
					if(is_file($dir.'/'.$obj)) { 
						$temp_attach[$i]["base64"] = chunk_split(base64_encode(file_get_contents(($dir .'/'. $obj)))); 
						$temp_attach[$i]["filename"] = $temp_filenames[$obj];
						$i++;
					}
				}
			}
		}
        //attach all files in temporary directory
		$files = array();
        $dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username");
        if(is_dir($dir)) {
            if($dh = opendir($dir)) {
                $dir_size = 0;
				$i = 0;
                while (false !== ($obj = readdir($dh))) {
                    if(is_file($dir.'/'.$obj)) { 
                        $dir_size += filesize($dir .'/'. $obj);
						//set filename on attachment to actual filename from temp filename, if it exists, otherwise use actual filename
						if(isset($temp_filenames[$obj])) {
							$file_types .= pathinfo($temp_filenames[$obj], PATHINFO_EXTENSION) . " "; //get file extension
							$files['attachment'.$i]['binary'] = file_get_contents($dir .'/'. $obj);
							$files['attachment'.$i]['filename'] = $temp_filenames[$obj];				
							$i++;
						}
						else {
							$file_types .= pathinfo($obj, PATHINFO_EXTENSION) . " "; //get file extension
							$files['attachment'.$i]['binary'] = file_get_contents($dir .'/'. $obj);
							$files['attachment'.$i]['filename'] = $obj;
							$i++;
						}
                    }
                }
                if($dir_size > MAX_ATTACHMENTS_SIZE*(1048576)) { 
                    $this->clear_attachments(); //remove attachments, they are too big to send
                    $this->save("draft",$temp_attach,TRUE,"Total attachment size is greater than 10 MB. "); 
                }
            }
        }
        
        //check for group membership for sending address
		if($this->session->userdata('mailbox_group') == $this->session->userdata('username')) {
			$email = $this->session->userdata('user_mail'); //address the email will be sent from
		}
		else if(strlen(trim($this->session->userdata('mailbox_group'))) <= 0) {
			$email = $this->session->userdata('username') . '@' . DIRECT_DOMAIN;
		}
		else {	$email = $this->session->userdata('mailbox_group') . '@' . DIRECT_DOMAIN; }
        
        $to_array = explode(";",$this->input->post('message_to',TRUE));
		$to_array = $this->check_dist_list_before_sending($to_array); //check for distribution lists
        $cc_array = explode(";",$this->input->post('message_cc',TRUE));
		$cc_array = $this->check_dist_list_before_sending($cc_array); //check for distribution lists   
        
		//get rid of working draft, as another will be saved if it fails and we want it gone if it succeeds
		if(isset($_SESSION['compose_draft_id'])) {
			$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}Drafts'); //change to drafts
			$this->peeker->delete_and_expunge(imap_msgno($this->peeker->resource,$_SESSION['compose_draft_id']));
			//change back to original mailbox
			if(isset($_SESSION['mailbox'])) {
				$this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}' . $_SESSION['mailbox']); 
			}
			else { $this->peeker->change_to_mailbox('{' . IMAP_HOSTNAME . ':' . IMAP_PORT .  IMAP_SERVICEFLAGS . '}INBOX'); }
		}
		
		
		//construct post request
		$fields = array(
			'sender' => $email,
			'to' => implode(';',$to_array),
			'cc' => implode(';',$cc_array),
			'subject' => $this->input->post('message_subject',TRUE),
			'body' => $body,
			'priority' => $priority,
		);
		
		$post = '';
		if(count($files) > 0) { 
			$boundary = hash('sha256',(time()));
			$content_type = 'multipart/form-data; boundary='.$boundary;
			$post .= '--'.$boundary."\r\n";
			foreach($fields as $name => $value) {
				$post .= 'Content-Disposition: form-data; name="'.$name.'"'."\r\n\r\n";
				$post .= $value."\r\n";
				$post .= '--'.$boundary."\r\n";
			}
			$i = 0;
			foreach($files as $key => $file) {
				$post .= 'Content-Disposition: form-data; name="'.$key.'"; filename="'.$file['filename'].'"'."\r\n";
				$post .= 'Content-Type: application/octet-stream'."\r\n";
				$post .= 'Content-Transfer-Encoding: binary'."\r\n\r\n";
				$post .= $file['binary']."\r\n";
				if($i === count($files)) { $post .= '--'.$boundary."--\r\n"; } else { $post .= '--'.$boundary."\r\n"; }
				$i++;
			}
		}
		else { 
			$content_type = "application/x-www-form-urlencoded";
			foreach($fields as $key=>$value) { $post .= $key.'='.urlencode($value).'&'; } //url-ify the data for the POST
			$post = rtrim($post, '&');
		}
		//set content type for hmac hash
		$raw_content_type = $content_type;
		if (strpos($raw_content_type, ";") > 0){
			$raw_content_type = substr($raw_content_type, 0, strpos($raw_content_type, ";"));
		}
		
		$headers = array(
					'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"POST\n" . date('U'). "\n". md5($post) . "\n" . $raw_content_type . "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
					'Date: ' . date('U'),
					'Content-Type: '. $content_type,
					'Content-Md5: ' . base64_encode(md5($post)),
					);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		if (curl_errno($ch) || $http_status != 200) {
			$failure = TRUE;
			$json_response = json_decode($server_output);
			$failure_reason = addslashes($json_response->message);
		}
		else {
			$failure = FALSE;
			curl_close($ch);
		}
		
        if($failure) {
            //print_r($server_output); //for debugging only
            $message_size = mb_strlen($body);
            //delete cache if any attachments were uploaded
            $attachments = array();
            $i = 0;
			if(is_dir($dir)) {
				if($dh = opendir($dir)) {
					while (false !== ($obj = readdir($dh))) {
						if(is_file($dir.'/'.$obj)) { 
							$attachments[$i]["base64"] = chunk_split(base64_encode(file_get_contents(($dir .'/'. $obj)))); 
							$attachments[$i]["filename"] = $temp_filenames[$obj];
							$message_size = $message_size + filesize($dir .'/'. $obj);
							$i++;
						}
					}
				}
			}
            //then clear the directory
            $this->clear_attachments();
            
            //log event
			//set from address for log
			if(isset($cn)) { $from_address = '"'.$cn.'" <'.$email.'>'; }
			else { $from_address = $email; }
            //audit is now done in java code
			//$this->audit->log_event("send",array(date('U'), ($message_size/1024), $from_address,json_encode(array_merge($to_array,$cc_array)), $file_types,FALSE));
            
            //attempt to save draft of failed message, save should redirect to proper location
            $this->save("draft",$attachments,TRUE,$failure_reason);
        }
        else {
            $message_size = mb_strlen($body);
            $this->session->set_flashdata('message_class','success');
            $this->session->set_flashdata('message','Message successfully sent.');
            //delete cache if any attachments were uploaded, also save attachment binaries for saving sent message
            $attachments = array();
            $i = 0;
            if(is_dir($dir)) {
                if($dh = opendir($dir)) {
                    while (false !== ($obj = readdir($dh))) {
                        if(is_file($dir.'/'.$obj)) { 
                            $attachments[$i]["base64"] = chunk_split(base64_encode(file_get_contents(($dir .'/'. $obj)))); 
                            $attachments[$i]["filename"] = $temp_filenames[$obj];
                            $message_size = $message_size + filesize($dir .'/'. $obj);
                            $i++;
                        }
                    }
                }
            }
            //then clear the directory
            $this->clear_attachments();
			//set from address for log
			if(isset($cn)) { $from_address = '"'.$cn.'" <'.$email.'>'; }
			else { $from_address = $email; }
			//audit is now done in java code
			//$this->audit->log_event("send",array(date('U'), ($message_size/1024), $from_address,json_encode(array_merge($to_array,$cc_array)), $file_types, TRUE));
            
            //attempt to save to sent messages, save should redirect to proper location
            $this->save("sent",$attachments);
        }
    }
    
    function attach() {
		if(isset($_FILES['attach'])) {
			$filename = $_FILES['attach']["name"]; //get filename
			$temp_name = uniqid($filename.'_');
			$_SESSION['temp_filenames'][$temp_name] = $filename;
			//if file has a name, then move it to the application cache with that name
			if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username"))) {
				mkdir($_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username"));
			}
			if($filename != "") {
				move_uploaded_file($_FILES['attach']['tmp_name'], $_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'.$temp_name);
				$filesize = filesize($_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata('username').'/'.$temp_name); //get filesize in bytes
				if($filesize <= MAX_ATTACHMENTS_SIZE*(1048576)) {
					if($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') { echo json_encode(array('token'=>$this->security->get_csrf_hash(),'filename' => $temp_name, 'filesize' => $filesize)); }
					else { echo '<textarea status="200">'.json_encode(array('token'=>$this->security->get_csrf_hash(),'filename' => $temp_name, 'filesize' => $filesize)).'</textarea>'; }
				}
				else {
					if($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') { 
						$this->clear_attachment($temp_name);
						show_error('Request entity too large',413); 
					}
					else { 
						$this->clear_attachment($temp_name);
						echo '<textarea status="413">Request Entity Too Large</textarea>'; 
					}
				}
			}
			else {
				if($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') { show_error('Bad Request',400); }
				else { echo '<textarea status="400">Bad Request</textarea>'; }
			}
		}
		else {
			if(empty($_FILES) && empty($_POST) && isset($_SERVER['REQUEST_METHOD']) && strtolower($_SERVER['REQUEST_METHOD']) == 'post') {
				if($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') { show_error('Request entity too large',413); }
				else { echo '<textarea status="413">Request Entity Too Large</textarea>'; }
			}
			else {
				show_404();
			}
		}
    }
    
    public function ajax_xml_check($filename) {
        $dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username");
        if(is_dir($dir)) {
            if(is_file($dir. '/' . $filename)) {
                $string = file_get_contents($dir. '/' . $filename);
                $xml = new DOMDocument; //load xml
                $xml->loadXml($string);
                //get schema to check if its a c32
                $schema = $xml->documentElement->getAttribute('xsi:schemaLocation'); 
                if(strpos($schema,"cdar2c32") !== FALSE || strpos($schema,"v3 CDA") !== FALSE) {
                    if($xml->getElementsByTagName('code')->item(0)->hasAttribute('displayName')) { $title = $xml->getElementsByTagName('code')->item(0)->getAttribute('displayName'); }
                    else if($xml->getElementsByTagName('title')->length > 0) { $title = $xml->getElementsByTagName('title')->item(0)->nodeValue; }
                    else { $title = "C32 Document"; }
                    if($xml->getElementsByTagName('patient')->length > 0 && $xml->getElementsByTagName('name')->length > 0) { $patient = $xml->getElementsByTagName('patient')->item(0)->getElementsByTagName('name')->item(0)->nodeValue; }
                    if($xml->getElementsByTagName('representedOrganization')->length > 0) { $org = $xml->getElementsByTagName('representedOrganization')->item(0)->getElementsByTagName('name')->item(0)->nodeValue; }
                    
                    //check for set values that are blnak to avoid confusing information
                    if(strlen($title) <= 0) { $title = "C32 Document"; }
                    if(isset($patient) && strlen(trim($patient)) <= 0) { $patient = "Unnamed Patient"; }
                    if(isset($org) && strlen(trim($org)) <= 0) { $patient = "Unnamed Organization"; }
                        
                    $display = $title;
                    if(isset($patient)) { $display .= " for " . $patient; }
                    if(isset($org)) { $display .= " from " . $org; }
                    echo preg_replace("/[\n\r]/","",$display);
                }
            }
        }
    }
    
    public function clear_attachment($filename) {
		$filename = html_entity_decode(rawurldecode($filename));
        $dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username");
        if(is_dir($dir)) {
            if(is_file($dir. '/' . $filename)) {
                if(!unlink($dir. '/' . $filename)) { show_error('Failed remove attachment due to internal error.',500); return FALSE; }
                else { return TRUE; }
            }
        }
        else { return TRUE; /* return TRUE if directory doesn't exist, since we wanted to delete the file in it anyway */}
    }
    private function clear_attachments() {
        $dir = $_SERVER['DOCUMENT_ROOT'].'/application/cache/'. $this->session->userdata("username");
        if(is_dir($dir)) {
            if($dh = opendir($dir)) {
                while (false !== ($obj = readdir($dh))) {
                    if(is_file($dir.'/'.$obj)) { unlink($dir.'/'.$obj); }
                }
            }
			unset($_SESSION['temp_filenames']); //clear out temporary filenames also
            return rmdir($dir);
        }
        else { return TRUE; /* return true if directory doesn't exist, since we wanted to delete it anyway */ }
    }
    
    public function get_attachment($message_id, $filename, $download = NULL, $download_type = NULL) {
        $this->imap_connect();
        if($this->peeker->connected) {
            $data["connected"] = TRUE;
            $filename = html_entity_decode(rawurldecode($filename));
			$file_type = pathinfo($filename, PATHINFO_EXTENSION);
            $msg = $this->peeker->get_message($message_id);
            $parts = $msg->get_parts_array();
            $string = "";
            $is_attachment = FALSE;
            
            foreach($parts as $part) {
                if(str_replace("/","",$part->filename) == $filename) { //compare filtered filenames
                    $string = $part->string;
                    $is_attachment = TRUE;
                }
            }
            if($filename != "" && $is_attachment == TRUE)
            {
                if($file_type == 'pdf') {
                    header("Content-Type: application/pdf");
                    header("Content-Disposition: inline; filename=\"" . $filename . "\"");
                    echo $string;
                }
				else if(($file_type == 'jpg' || $file_type == 'jpeg' || $file_type == 'png' || $file_type == 'gif') && (!is_null($download) && $download === 'download')) {
					header("Content-Type: application/octet-stream");
                    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                    header("Content-Transfer-Encoding: binary");
					echo $string;
				}
				else if($file_type == 'jpg' || $file_type == 'jpeg' || $file_type == 'png' || $file_type == 'gif') {
					header('Content-Type: image/'. $file_type);
                    header('Content-Disposition: inline; filename="' . $filename . '"');
					echo $string;
				}
                else if($file_type == 'xml' && (!is_null($download) && $download == "download") && (is_null($download_type))) {
                    header("Content-Type: application/octet-stream");
                    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                    header("Content-Transfer-Encoding: binary");
                    echo $string;
                }
                else if($file_type == 'xml') {
                    $xml = new DOMDocument; //load xml
                    $xml->loadXml($string);
                    //get schema to check if its a c32
                    $schema = $xml->documentElement->getAttribute('xsi:schemaLocation'); 
                    if(strpos($schema,"cdar2c32") !== FALSE || strpos($schema,"v3 CDA") !== FALSE) {
                        $xsl_location = $_SERVER['DOCUMENT_ROOT'].'/application/views/c32.xsl'; //TO-DO: make config item?
                        $xsl_string = file_get_contents($xsl_location);
                        if(isset($xsl_string) && $xsl_string) {
                            $xsl = new DOMDocument; //load xsl
                            $xsl->loadXml($xsl_string);
                            $proc = new XSLTProcessor;
                            $proc->importStyleSheet($xsl); // attach the xsl rules
                            $transform = $proc->transformToXML($xml);
                            if($transform) { 
                                if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username"))) { mkdir($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username")); }
                                file_put_contents($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'."temp.html",$transform);
                                shell_exec("wkhtmltopdf " . '--footer-center "FOR OFFICIAL USE ONLY" ' . escapeshellarg($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'."temp.html") . " " 
								. escapeshellarg($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'."temp.pdf") . " 2>&1");
                                $pdf = file_get_contents($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata("username").'/'."temp.pdf");
                                if((!is_null($download) && $download == "download") && (!is_null($download_type) && $download_type == "pdf"))
                                { 
                                    header('Content-Type: application/download');
                                    header("Content-Disposition: attachment; filename=\"" . $filename . ".pdf\"");
                                    header("Content-Transfer-Encoding: binary");
                                    echo $pdf;
                                }
                                else { echo $transform; }
                                $this->clear_attachments();
                            }
                            else { //download as usual if transformation fails
                                header('Content-Type: application/download');
                                header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                                header("Content-Transfer-Encoding: binary");
                                echo $string;
                            }
                        }
                    }
                    //if not download it as normal
                    else {
                        header('Content-Type: application/download');
                        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                        header("Content-Transfer-Encoding: binary");
                        echo $string;
                    }
                }
                else {
                    header("Content-Type: application/force-download");
                    header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
                    header("Content-Transfer-Encoding: binary");
                    echo $string;
                }
            }
            $this->peeker->close();
        }
        else {
			//load theme info into view data
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
            $data["title"] = PORTAL_TITLE_PREFIX . "Lost Connection";
            $data["connected"] = FALSE;
            $data["headers"] = "Lost connection to mail server. Check internet connection, then click <a href=\"/inbox\">here</a> to reconnect.";
            $this->load->view('inbox/index',$data);
        }
    }
	
	/* This function allows the user to preview an attachment stored in their personal attachment cache
	 */
	public function preview_attachment($tmp_name) {
		$tmp_name = html_entity_decode(rawurldecode($tmp_name));
		//check if user has a cache of attachments available
		if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata('username'))) { show_404(); }
		else {
			//check if the specified filename exists
			if(!file_exists($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata('username').'/'.$tmp_name)) { show_404(); }
			else {
				$filename = str_replace(substr($tmp_name,strrpos($tmp_name,'_')),'',$tmp_name);
				$file_type = pathinfo($filename, PATHINFO_EXTENSION);
				if($file_type == 'pdf') {
					header('Content-Type: application/pdf');
                    header('Content-Disposition: inline; filename="' . $filename . '"');
					echo file_get_contents($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata('username').'/'.$tmp_name);
				}
				else if($file_type == 'jpg' || $file_type == 'jpeg' || $file_type == 'png' || $file_type == 'gif') {
					header('Content-Type: image/'. $file_type);
                    header('Content-Disposition: inline; filename="' . $filename . '"');
					echo file_get_contents($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata('username').'/'.$tmp_name);
				}
				else {
					header('Content-Type: application/download');
					header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
					header("Content-Transfer-Encoding: binary");
					echo file_get_contents($_SERVER['DOCUMENT_ROOT'].'/application/cache/'.$this->session->userdata('username').'/'.$tmp_name);
                }
			}
		}
	}

    /* This function takes an image attachment stored in session and loads a view that will display it
     */
    public function imgdisp($id,$filename,$inline=NULL) {
        $data['id'] = $id;
        $data['filename'] = $filename;
        if(!is_null($inline)) { $data['inline'] = $inline; }
        $this->imap_connect();
        $this->load->view("inbox/imgdisp",$data);
        $this->peeker->close();
    }

	/* This function displays the create folder form view, meant for use with a modal window or pop-up */
	public function create_folder_form() {
		$this->load->view('inbox/create_folder_form');
	}
	
	/*This function creates a folder from the submitted create folder form data */
    public function create_folder() {
        $name = $this->input->post("folder_name",TRUE);
		if(strlen($name) <= 0) {
			$this->session->set_flashdata('message','Failed to create folder. Folder name cannot be blank.');
			$this->session->set_flashdata('message_class','error');
			redirect('inbox');
			return FALSE;
		}
        $this->imap_connect();
        //create mailbox
		$mailbox_group = $this->session->userdata('mailbox_group');
		$success = FALSE;
		if(strlen(trim($mailbox_group)) > 0) {
				if($mailbox_group != $this->session->userdata('username')) {
					$success = imap_createmailbox($this->peeker->resource, "{".$this->peeker->host.":".$this->peeker->port. $this->peeker->service_flags ."}" . GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.' . CUSTOM_MAILBOX_PREFIX . $name);
				}
				else {
					$success = imap_createmailbox($this->peeker->resource, "{".$this->peeker->host.":".$this->peeker->port. $this->peeker->service_flags ."}" . CUSTOM_MAILBOX_PREFIX . $name);
				}
		}
		else {
			$success = imap_createmailbox($this->peeker->resource, "{".$this->peeker->host.":".$this->peeker->port. $this->peeker->service_flags ."}" . CUSTOM_MAILBOX_PREFIX . $name);
        }
		//refresh mailbox list
		if($success) {
			$this->session->set_flashdata('message','Folder successfully created.');
			$this->session->set_flashdata('message_class','success');
		}
		else {
			$this->session->set_flashdata('message','Failed to create folder.');
			$this->session->set_flashdata('message_class','error');
		}
		$_SESSION['mailbox_list'] = $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);
        $this->peeker->close();
        redirect("inbox");
    }

    /* This function archives all messages in a folder, then deletes the folder.
     */
    function archive_folder($folder_str) {
		//figure out mailbox prefix
		$mailbox_group = $this->session->userdata('mailbox_group');
		if(strlen(trim($mailbox_group)) > 0) {
				if($mailbox_group != $this->session->userdata('username')) {
					$folder_prefix = GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.' . CUSTOM_MAILBOX_PREFIX;
				}
				else { $folder_prefix = CUSTOM_MAILBOX_PREFIX; }
		}
		else { $folder_prefix = CUSTOM_MAILBOX_PREFIX; }
		
        $folder_str = base64_decode(rawurldecode($folder_str));
        
        $this->imap_connect();
        $mailboxes = $this->peeker->get_mailboxes();
        
        //first check if the folder already exists with the same name
        foreach($mailboxes as $mailbox_conn_str) {
            $pos = strpos($mailbox_conn_str,$folder_prefix . $folder_str);
            if($pos !== FALSE && $pos == (strlen($mailbox_conn_str) - strlen($folder_prefix . $folder_str))) {
                $this->peeker->change_to_mailbox($mailbox_conn_str);
                for($i = $this->peeker->get_message_count(TRUE); $i >= 1; $i--) {
                    $this->archive(imap_uid($this->peeker->resource,$i));
                }
                if($this->peeker->get_message_count(TRUE) == 0) {
                    $success = imap_deletemailbox($this->peeker->resource,$mailbox_conn_str);
                    if(!$success) { /*Failed to archive folder */ }
                }
                else {  /*Failed to archive all messages in folder */  }
            }
        }

        //refresh mailbox list
        $_SESSION['mailbox_list'] = $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);
        $data["mailboxes"] = $_SESSION['mailbox_list'];
        
        $this->peeker->close();
        redirect("inbox");
    }
    
     /* This function renames IMAP folders that the user has created with this application.
     * The function will check for the prefix that the application attaches to custom folders so that it replaces only
     * custom folders. It accepts the new folder name as a post value from the jeditable editable input and the old folder name
     * as a parameter passed to the function.
     */
    function rename_folder($folder_str) {
		//decode parameters
		if(isset($folder_str)) {
			$folder_str = base64_decode(html_entity_decode(rawurldecode($folder_str)));
		}
		else {
			show_404(); return FALSE;
		}
		
        //figure out mailbox prefix
		$mailbox_group = $this->session->userdata('mailbox_group');
		if(strlen(trim($mailbox_group)) > 0) {
				if($mailbox_group != $this->session->userdata('username')) {
					$folder_prefix = GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.' . CUSTOM_MAILBOX_PREFIX;
				}
				else { $folder_prefix = CUSTOM_MAILBOX_PREFIX; }
		}
		else { $folder_prefix = CUSTOM_MAILBOX_PREFIX; }
        $new_folder_str = $this->input->post('value',TRUE);
		if(strlen($new_folder_str) <= 0) { $new_folder_str = $this->input->post('value_'.hash('sha256',$folder_str),TRUE); }
		if(strlen($new_folder_str) <= 0) { show_404(); return FALSE; } //if still blank, throw 404
		
        $this->imap_connect();
        $mailboxes = $this->peeker->get_mailboxes();
        
		$folder_str_id = hash('sha256',$folder_str);
		$js_safe_new_folder_str = str_replace("'","\'",$new_folder_str);
		$js_safe_folder_str = str_replace("'","\'",$folder_str);
		
        //first check if the folder already exists with the same name
        foreach($mailboxes as $mailbox_conn_str) {
            $pos_new = strpos($mailbox_conn_str,$folder_prefix . $new_folder_str);
            if($pos_new !== FALSE && $pos_new == (strlen($mailbox_conn_str) - strlen($folder_prefix . $new_folder_str))) { 
				//get the unseen message count for the mailbox if it exists
				$unseen = (isset(imap_status($this->peeker->resource,$mailbox_conn_str,SA_UNSEEN)->unseen)) ? (imap_status($this->peeker->resource,$mailbox_conn_str,SA_UNSEEN)->unseen) : (0);
				if($unseen > 0) { $show_unseen = " (" . $unseen . ")"; }
				else { $show_unseen = ""; }
				
				//if the folder name hasn't been changed
				if($folder_str == $new_folder_str) {
					echo $folder_str . "<script>" .
											"$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').css('display','none'); ".
											"$('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_new_folder_str . $show_unseen."'); ".
											"$('#' + '" . $folder_str_id . "').parent().children('a').css('display','block'); ".
											"$('#' + '" . $folder_str_id . "').parent().children('a').focus(); ".
										"</script>";
				}
				//if the folder name is different, but a folder already exists with that name
				else {
					echo $folder_str . "<script>$('#' + '" . 
								 $folder_str_id . "').parent().children('#custom_folder_name').css('display','none');
								 $('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_folder_str . $show_unseen."');
								 $('#' + '" . $folder_str_id . "').parent().children('a').css('display','block'); 
								 alert('Folder with this name already exists, could not rename folder.');</script>";
				}
                return false; 
            }
        }
        
        //if the new folder name does not exist, make sure the old folder exists
        foreach($mailboxes as $mailbox_conn_str) {
            $pos_old = strpos($mailbox_conn_str,$folder_prefix . $folder_str);
            if($pos_old !== FALSE && $pos_old == (strlen($mailbox_conn_str) - strlen($folder_prefix . $folder_str))) {
                $old_conn_str = $mailbox_conn_str;
                $new_conn_str = str_replace($folder_str, $new_folder_str, $mailbox_conn_str);
				
				//get the unseen message count for the mailbox if it exists
				$unseen = (isset(imap_status($this->peeker->resource,$old_conn_str,SA_UNSEEN)->unseen)) ? (imap_status($this->peeker->resource,$old_conn_str,SA_UNSEEN)->unseen) : (0);
				if($unseen > 0) { $show_unseen = " (" . $unseen . ")"; }
				else { $show_unseen = ""; }
							      
				//if the current mailbox is the mailbox is the one we are trying to change, we need to switch to another before changing it
				if(isset($_SESSION['mailbox']) && $_SESSION['mailbox'] == trim($new_folder_str)) {
					$this->peeker->change_to_mailbox("INBOX");
					$success = imap_renamemailbox($this->peeker->resource,$old_conn_str,$new_conn_str);
					$this->peeker->change_to_mailbox($_SESSION['mailbox']);
				}
				//otherwise just do it
				else { $success = imap_renamemailbox($this->peeker->resource,$old_conn_str,$new_conn_str); }
				//and get a response to send back
				if($success) { echo $this->build_rename_response('success',$folder_str, $new_folder_str, $folder_prefix, $show_unseen); }
				else { echo $this->build_rename_response('failure',$folder_str, $new_folder_str, $folder_prefix, $show_unseen); }
            }
        }
        //refresh mailbox list
        $_SESSION['mailbox_list'] = $this->mailformat->mailbox_list_format($this->peeker->get_mailboxes(),$this->peeker->resource,$this->peeker->host,$this->peeker->port,$this->peeker->service_flags);
        $data["mailboxes"] = $_SESSION['mailbox_list'];
        
        $this->peeker->close();
    }
	
	private function build_rename_response($response_type, $folder_str, $new_folder_str, $folder_prefix, $show_unseen) {
		$folder_str_id = hash('sha256',$folder_str);
		$js_safe_new_folder_str = str_replace("'","\'",$new_folder_str);
		$js_safe_folder_str = str_replace("'","\'",$folder_str);
		
		if($response_type == 'success') {
			echo $new_folder_str .
				"<script>$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').css('display','none'); ". //hide the span used for edit
					"$('#' + '" . $folder_str_id . "').parent().children('a').attr('title', '" . $new_folder_str . $show_unseen . "'); ". //change the title tooltip to new mailbox name
					"$('#' + '" . $folder_str_id . "').parent().children('a').attr('href', '".base_url() . 'inbox/change_mailbox/' . rawurlencode(base64_encode($folder_prefix . $new_folder_str))."'); ". //change link href to new mailbox link
					"$('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_new_folder_str . $show_unseen."'); " . //change link text to new mailbox name
					"$('#' + '" . $folder_str_id . "').parent().children('a').css('display', 'block'); ". //show the link again now that it is updated
					"$('#' + '" . $folder_str_id . "').parent().children('a').focus(); ".//focus on after change
					"$('#' + '" . $folder_str_id . "').attr('id','" . hash('sha256',$new_folder_str) . "'); ". //set the id of the overall list item that associates all these elements with the mailbox name
					//reset the onclick event for the hidden button in the accessibility menu to use new mailbox
					"$('#rename_folder_" . $folder_str_id . "').attr('onclick','".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'#custom_folder_name\').css(\'display\', \'inline\');".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'a\').css(\'display\', \'none\');".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'#custom_folder_name\').editable(\'/inbox/rename_folder/".
						rawurlencode(base64_encode($new_folder_str))."/\', { event : \'rename_event\', height: 12, width: 100, style : \'position: relative; float: right; z-index: 100;\', onblur : \'submit\',indicator : \'Saving...\', callback: function(value, settings) { $(this).unbind(settings.event);}}); ".
						"$(\'[id=\"".hash('sha256',$new_folder_str)."\"]\').parent().children(\'#custom_folder_name\').trigger(\'rename_event\');".
					"');".
					"$('#rename_folder_" . $folder_str_id . "').attr('id', 'rename_folder_" . hash('sha256',$new_folder_str) . "'); ". //set the id of the button to use new mailbox hash
					"$('#archive_folder_" . $folder_str_id . "').attr('href', '/inbox/archive_folder/".rawurlencode(base64_encode($new_folder_str))."/'); ". //set the hidden archive folder link to use new mailbox
					"$('#archive_folder_" . $folder_str_id . "').html('Archive Folder: " . ($new_folder_str) . "'); ". //set hidden archive folder link to display new mailbox name
					"$('#archive_folder_" . $folder_str_id . "').attr('id', 'archive_folder_" . hash('sha256',$new_folder_str) . "'); ". //set new id for archive folder link using new mailbox hash
					"$('#rename_folder_label_" . $folder_str_id . "').attr('for', 'rename_folder_" . hash('sha256',$new_folder_str) . "'); ". //set label for the hidden button to use new id
					"$('#rename_folder_label_" . $folder_str_id . "').attr('id', 'rename_folder_label_" . hash('sha256',$new_folder_str) . "'); ". //set id for the label to use the new mailbox hash
				"</script>"; 
		}
		else if($response_type == 'failure') {
			return $folder_str . $show_unseen . 
					"<script>".
						"$('#' + '" . $folder_str_id . "').parent().children('#custom_folder_name').css('display','none');". //hide the editable span
						"$('#' + '" . $folder_str_id . "').parent().children('a').html('".$js_safe_folder_str . $show_unseen."');". //change the inner HTML of the link back to what it was
						"$('#' + '" . $folder_str_id . "').parent().children('a').css('display','block');". //show the link again
						"alert('Error while renaming folder, folder not renamed.');". //alert the user to the error
					"</script>";
		}
	}
    
    /* This function prints a folder list in JSON
     */
    function json_folder_list($echo = TRUE) {
        $this->imap_connect();
        $mailboxes = $this->peeker->get_mailboxes();
        $mailbox_group = $this->session->userdata('mailbox_group');
		
        if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->session->userdata("username")) { $inbox_str = "{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}" . GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'."INBOX"; }
		else { $inbox_str = "{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}INBOX"; }
		$inbox_location = array_search($inbox_str, $mailboxes);
		$mailboxes[$inbox_location] = 0; 
		$mailboxes = array_filter($mailboxes);
		$mailboxes = array_merge(array($inbox_str), $mailboxes);
        
        $custom_mailboxes = array();
        $i = 0;
        foreach($mailboxes as $mailbox) {
            if(strpos($mailbox,CUSTOM_MAILBOX_PREFIX) !== FALSE) { array_push($custom_mailboxes,$mailbox); $mailboxes[$i] = 0; }
            $i++;
        }
        $mailboxes = array_filter($mailboxes);
        $mailboxes = array_merge($mailboxes,$custom_mailboxes);
        
        $data = array();
        $i = 0;
		
        foreach($mailboxes as $mailbox) {
			$display_mailbox = TRUE;
			$mailbox = str_replace("{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}","",$mailbox);
			//check if group mailboxes need to be accounted for
			if(strlen(trim($mailbox_group)) > 0) {
				if($mailbox_group != $this->session->userdata('username')) {
					if($this->mailformat->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") == $mailbox) { $display_mailbox = FALSE; }
				}
				else {
					if($this->mailformat->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") != $mailbox) { $display_mailbox = FALSE; }
				}
			}
            
            if($display_mailbox) {
				$data[$i]['link'] = rawurlencode(base64_encode($mailbox));
				if(strlen(trim($mailbox_group)) > 0) {
					if($mailbox_group != $this->session->userdata('username')) { 
						$mailbox = $this->mailformat->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX.'.'.$mailbox_group.'.','');
					}
				}
				$data[$i]['label'] = $this->mailformat->replaceFirst($mailbox,CUSTOM_MAILBOX_PREFIX,"");
				$i++;
			}
        }
		//only echo if the request comes from AJAX
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&  $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
			if($echo) { echo json_encode($data); } 
		}
		if(!$echo) { return json_encode($data); }
        $this->peeker->close();
    }
	
	/* This function allows the user to change their currently selected mailbox group */
	public function change_mailbox_group($group) {
		$group = rawurldecode($group);
		$this->session->set_userdata('mailbox_group',$group);
		if($this->session->userdata('mailbox_group') != $this->session->userdata('username')) {
			$ldapconfig['user'] = $this->session->userdata('username');
			$ldapconfig['pwd'] = $this->encrypt->decode($this->session->userdata('ep'));
			$this->load->library("ldap",$ldapconfig);
			$ldap_lookup = $this->ldap->search(NULL,1,array('cn'),'(&(ObjectClass=groupOfNames)(ou=' . $group . '))',LDAP_BASE_DOMAIN);
			$this->session->set_userdata('mailbox_group_cn',$ldap_lookup[0]['cn']);
			$_SESSION['mailbox'] = GROUP_MAILBOX_PREFIX . '.'. $this->session->userdata('mailbox_group') . '.' . "INBOX";
		}
		else {
			$this->session->set_userdata('mailbox_group_cn','Personal (' . $this->session->userdata('username') . ')');
			$_SESSION['mailbox'] = "INBOX";
			
		}
		redirect('inbox');
	}
	
	public function valid_formatted_address($str) {
		$valid_format = (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $str)) ? FALSE : TRUE;
		return $valid_format;
	}

	/* This searches the address book and contacts list and returns JSON encoded results for the auto-complete */
	public function get_contacts_search($input = null, $function = false){  
        $input = urldecode($input);
		$this->load->database();
		$this->load->model('private_distribution_list_model','privdistlist');
		if(is_null($input)) { $input = ""; }
		$result_arr = array();
		$added_addresses = array();
		//get addresses from global address book in LDAP
		$ldapconfig['user'] = $this->session->userdata('username');
		$ldapconfig['pwd'] = $this->encrypt->decode($this->session->userdata('ep'));
		$this->load->library('ldap',$ldapconfig);
		$entries = ($this->ldap->search($input));
		foreach($entries as $key => $val) {
			if($this->valid_formatted_address($val['mail'])) {
				$contact_arr = array('name'=>(isset($val['displayname'])?$val['displayname']:"Undefined"),'id'=>$val['mail']);
				array_push($result_arr,$contact_arr);
				array_push($added_addresses,$contact_arr['id']);
			}
		}
		if(!$function){
			//get global distribution lists
			$this->load->model('public_distribution_list_model','pubdistlist');
			$this->load->model('distribution_list_model','distlist');
			$list_result = $this->pubdistlist->find(array('cn'=>$input.'*'));
			
			foreach($list_result as $index => $entry) {
				$address_tokens = array();
				$list_result[$index]['id'] = $this->pubdistlist->alias($entry['id']);
				$list_result[$index]['description'] = '(Global) '.$list_result[$index]['description'];
				
				if(!empty($list_result[$index]['addresses'])){
					//get display names and addresses for distribution list expansion
					$address_array = preg_split("/;/", $list_result[$index]['addresses'], null, PREG_SPLIT_NO_EMPTY);
					$display_names_array = $this->distlist->display_names_for_direct_addresses($address_array);
					foreach($address_array as $address) {
						if(!isset($display_names_array[$address])) {
							$display_names_array[$address] = trim($address);
						}
					}
					foreach($display_names_array as $address => $display_name) {
						array_push($address_tokens,$display_name . ' (' . trim($address) . ')');
					}
					
					$display_names = implode('; ', $display_names_array);
					$addresses_in_display_order = implode('; ', array_keys($display_names_array));
					$list_result[$index]['display_names'] = $display_names;
					$list_result[$index]['addresses_in_display_order'] = $addresses_in_display_order;
					$list_result[$index]['address_tokens'] = json_encode($address_tokens);
					array_push($result_arr,$list_result[$index]);
				}
			}
		}
		
		//get contacts from contact list in database
        $contacts = $this->db->query('SELECT * FROM contacts WHERE (last_name LIKE (' . $this->db->escape($input) . "+ '%') OR mail LIKE (" . $this->db->escape($input) . "+ '%')) AND user_id = (SELECT user_id FROM users WHERE  user_deleted_flag=0 AND user_name = " . $this->db->escape($this->session->userdata("username")) . ")"); 
		for($i = 0; $i < $contacts->num_rows(); $i++) {
			$row = $contacts->row_array($i);
			$displayname = $row['last_name'] . ', ' . $row['first_name'];
			if(isset($row['middle_name']) && (strlen($row['middle_name']) > 0)) { $displayname .= ' ' . $row['middle_name']; }
			
			if($this->valid_formatted_address($row['mail'])){
				$contact_arr = array('name' => $displayname, 'id' => $row['mail']);
				//don't return blank/null attributes
				foreach($contact_arr as $attr => $val) {
					if(!isset($val) || strlen($val) <= 0) {
						unset($contact_arr[$attr]);
					}
				}
				if($function){
					$wasadded = array_search($contact_arr['id'],$added_addresses);
					if (!($wasadded === 0 || $wasadded > 0 )){
						array_push($result_arr,$contact_arr);
						array_push($added_addresses,$contact_arr['id']);
					}
				}
				else{
					array_push($result_arr,$contact_arr);
				}
			}
		}
		if(!$function){
			//get private distribution lists and load into results array
			$this->db->order_by('name');
			$this->db->like('name',$input,'after');
			$dist_list_result = $this->privdistlist->find(array());
			for($i = 0; $i < count($dist_list_result); $i++) {
				$address_tokens = array();
				$row = $dist_list_result[$i];
				$list_arr = array('name'=>$row['name'],'id'=>$this->privdistlist->alias($row['id']),'description'=>'(Private) '.$row['description']);
				//don't return blank/null attributes
				foreach($list_arr as $attr => $val) {
					if(!isset($val) || strlen($val) <= 0) {
						unset($list_arr[$attr]);
					}
				}
				if(!empty($row['addresses'])){
					//get display names and addresses for distribution list expansion
					$address_array = preg_split("/;/", $row['addresses'], null, PREG_SPLIT_NO_EMPTY);
					$display_names_array = $this->distlist->display_names_for_direct_addresses($address_array);
					foreach($address_array as $address) {
						if(!isset($display_names_array[$address])) {
							$display_names_array[$address] = trim($address);
						}
					}
					foreach($display_names_array as $address => $display_name) {
						array_push($address_tokens,$display_name . ' (' . trim($address) . ')');
					}
					$display_names = implode('; ', $display_names_array);
					$addresses_in_display_order = implode('; ', array_keys($display_names_array));
					$list_arr['display_names'] = $display_names;
					$list_arr['addresses_in_display_order'] = $addresses_in_display_order;
					$list_arr['address_tokens'] = json_encode($address_tokens);
					array_push($result_arr,$list_arr);
				}
			}
		}
		//sort combined result array (natural order, case insensitive)
		usort($result_arr, function( $el1, $el2) { return strnatcasecmp( $el1['name'], $el2['name']); });
		
		//add whatever the user is currently typing so that it is allowed as well
		if($this->valid_formatted_address($input)) {
			$contact_arr = array('name' => $input, 'id' => $input);
			array_push($result_arr,$contact_arr);
		}
		array_walk_recursive($result_arr, function (&$value) {
			$value = htmlentities($value);
		});
		//only echo if the request comes from AJAX
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest' && !$function) {
			echo json_encode($result_arr);
		}
		return $result_arr;
	}
	
	public function valid_trusted_address($str) {
		$str_array = explode(';',base64_decode(rawurldecode($str)));
		$str_array = $this->check_dist_list_before_sending($str_array); //check for distribution lists
		$str = rawurlencode(base64_encode(implode(';',$str_array)));
		
		$resource = '/direct/validate/address/'.$str.'/format/json';
		$url = WEBSERVICE_URL . $resource;
		
		$headers = array(
			'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"GET\n" . date('U'). "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
			'Date: ' . date('U'),
			);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		echo $server_output; //echo the output so that JS can use it
		$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$response = json_decode($server_output);
		if(isset($response->valid)) {
			$valid = $response->valid;
			return $valid;
		}
		else { return FALSE; }
	}
	
	/*Displays the feedback form view, meant for use in a modal window or pop-up */
	public function feedback_form() {
		$this->load->view('inbox/feedback_form');
	}
	
	/*Displays the feedback form view, meant for use in a modal window or pop-up */
	public function assign_search_menu() {
		$this->load->view('inbox/assign_message');
	}
	
	/*Distribution list methods */
	public function create_list()
	{
		$this->load->library("form_validation");
		$this->load->library('audit'); 
		$data['form'] = '/inbox/create_list';
		if($this->form_validation->run('distribution_list') == true) {
			$name = $this->input->post("list_display_name",TRUE);
			$this->load->model('private_distribution_list_model');
			$values = array('name'=> $name,'description'=>$this->input->post("list_description",TRUE));
			$id = $this->private_distribution_list_model->create($values);
			if(!empty($id)){
				$this->edit_list($id);
			}
			else{
				$form_data = $this->input->post(NULL);
				$data['form_data'] = $form_data;
				$this->load->view("addressbook/add_distribution_list",$data);
			}
		}
		else {
			$form_data = $this->input->post(NULL);
			$form_data['list_display_name']=html_entity_decode($form_data['list_display_name'],ENT_QUOTES);
			if(isset($form_data['list_description'])){$form_data['list_description']=html_entity_decode($form_data['list_description'],ENT_QUOTES);}
			$data['form_data'] = $form_data;
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				$data['validation_errors'] = $validation_errors;
			}
			$this->load->view("/addressbook/add_distribution_list",$data); //load view
		}
	}
	
	/* Used as a form validation callback to verify that the name is available for the list */
	public function list_is_unique($name) {
		$this->load->model('private_distribution_list_model');
		$this->form_validation->set_message('list_is_unique', 'This %s is already in use.  Please choose another value.');
		
		$name_is_available = $this->private_distribution_list_model->name_is_available($name);
		if($name_is_available) return true;
			
		//if we're editing (edit_distribution_list or e), check to see if the name is being used by the list we're editing
		if(string_begins_with('edit', $this->router->method) && string_ends_with('distribution_list', $this->router->method)){
			$list = $this->private_distribution_list_model->find_one(compact('name'));
			return $list['id'] == $this->input->post('list_id');			
		}
		
		return $this->private_distribution_list_model->name_is_available($name);
	}
	
	
	public function edit_distribution_list() {
		$this->load->library("form_validation");
		$this->load->model('private_distribution_list_model','pubdistlist');
		$list_display_name = $this->input->post('list_display_name',TRUE);
		$list_description = $this->input->post('list_description',TRUE);
		$list_members = $this->input->post('list_members',TRUE);
		$list_id = $this->input->post('list_id',TRUE);
		if(!is_array($list_members) || count($list_members) === 0) { $list_members = array(); } //if no members, give empty array
		
		//set valdiation rules		
		if($this->form_validation->run('distribution_list') === TRUE) {
			//update display name and description
			$attributes = array(
				'name' => $list_display_name,
				'description' => $list_description,
			);
			 $this->pubdistlist->update($list_id,$attributes);
			//update addresses
			$addresses_in_list = $this->pubdistlist->addresses_for_list($list_id);
			$addresses_to_add = array_diff($list_members,$addresses_in_list);
			$addresses_to_remove = array_diff($addresses_in_list,$list_members);
			foreach($addresses_to_add as $address) {
				 $this->pubdistlist->add_address_to_list($list_id,$address);
			}
			foreach($addresses_to_remove as $address) {
				 $this->pubdistlist->remove_address_from_list($list_id,$address);
			}
		}
		else {
			//validation fails
			$form_data = $this->input->post(NULL);
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				echo json_encode($validation_errors);
			}
		}
	}
	public function edit_list($list_id)	{
		$this->load->library('audit'); 
		$this->load->model('private_distribution_list_model');
		if(!$this->private_distribution_list_model->formatted_like_an_id($list_id))
			show_404();
		$list=$this->private_distribution_list_model->find_one($list_id);
		if($list === false  || $list['created_by'] !== $this->user_model->logged_in_user('user_id')){
			show_404();
		}
		$data['list_id'] = $list_id;
		$data['form'] = 'inbox/edit_distribution_list';
		$data['addresses'] = $this->private_distribution_list_model->addresses_for_list($list);
		$form_data = $this->input->post(NULL);
		$form_data['list_description']= $list['description'];
		$form_data['list_display_name']= $list['name'];
		$data['form_data'] = $form_data;
		
		//set up the options for the multiselect
		$user_options = array();
		foreach($this->get_contacts_search(null, true) as $user){
			$email = strtolower(trim($user['id']));
			$user_options[$email] =  $user['name'] . ' ('.$email.')';
		}
		
		$external_addresses = array_diff($data['addresses'], array_keys($user_options));
		foreach($external_addresses as $external_address){
			$user_options[$external_address] = $external_address;
		}
		natcasesort($user_options);		
		$data['user_options'] = $user_options;		
		
		$this->load->view("/addressbook/edit_distribution_list",$data); //load view
		
	}
	
	public function remove_list($list_id)
	{
		
		$this->load->library("form_validation");
		$this->load->library('audit'); 
		if($list_id === null){
			show_404();
		}
		$this->load->model('private_distribution_list_model');
		$list=$this->private_distribution_list_model->find_one($list_id);
		if($list === false  || $list['created_by'] !== $this->private_distribution_list_model->logged_in_user_id()){
			show_404();
		}
		$this->private_distribution_list_model->delete($list_id);
	}
	/*assign message to me*/
	public function assign_to_me($id ,$db_id = null){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		if ($db_id === null){//status id
			$results = $this->workflow_model->find_for_message($id);
			if($results === false){
				echo $this->create_message_status($id, $this->user_model->logged_in_user('user_id'),0);
				return;
			}
		}
		else{// database id
			$results = $this->workflow_model->find_one($db_id);
		}
		if(is_array($results)){
			if($results['assigned_to'] === null || $results['assigned_to'] === $this->user_model->logged_in_user('user_id')){
					echo $this->update_message_status($id ,$db_id, $this->user_model->logged_in_user('user_id'), 0);
			}
			else{
				$results['success'] = false;
				$results['error'] = "already assigned";
				$results['assigned_to'] =  $this->user_model->user_cn_from_id($results['assigned_to']);
				echo json_encode($results);
			}
		}
		else{
			echo json_encode(array('success'=>false,'error'=>'failed to get results'));
		}
	}
	/*assign message to someone*/
	public function assign_message_status($id,$user_id){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		echo $this->create_message_status($id, $user_id,0);
	}
	/*assign message to someone*/
	public function complete_message($id, $db_id = null){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		if ($db_id === null){//status id
			$results = $this->workflow_model->find_for_message($id);
			if($results === false){
				echo $this->create_message_status($id, $this->user_model->logged_in_user('user_id'),1);
				return;
			}
		}
		else{// database id
			$results = $this->workflow_model->find_one($db_id);
		}
		if(is_array($results)){
			if($results['assigned_to'] === null || $results['assigned_to'] === $this->user_model->logged_in_user('user_id')){
					echo $this->update_message_status($id ,$db_id, $this->user_model->logged_in_user('user_id'), 1);
			}
			else{
				$results['success'] = false;
				$results['error'] = "already assigned";
				$results['assigned_to'] =  $this->user_model->user_cn_from_id($results['assigned_to']);
				echo json_encode($results);
			}
		}
		else{
			echo json_encode(array('success'=>false,'error'=>'failed to get results'));
		}
	}
	/*reset message*/
	public function reset_message_status($id, $db_id = null){
		$this->load->model('workflow_model');
		$id = str_replace("status_", "", $id);
		$results = $this->workflow_model->find_for_message($id);
		if($results === false){
			return;
		}
		if(is_array($results)){
			if($results['assigned_to'] === null || $results['assigned_to'] === $this->user_model->logged_in_user('user_id')){
				if($this->workflow_model->remove_from_message($id)){
					echo json_encode(array('success'=>true));
				}else{
					echo json_encode(array('success'=>false,'error'=>'failed to remove'));
				}
			}
			else{
				$results['success'] = false;
				$results['error'] = "already assigned";
				$results['assigned_to'] =  $this->user_model->user_cn_from_id($results['assigned_to']);
				echo json_encode($results);
			}
		}
		else{
			echo json_encode(array('success'=>false,'error'=>'failed to get results'));
		}
	}
	private function create_message_status($id, $assigned, $complete){
		$value = $this->workflow_model->set_for_message($id, array('assigned_to'=>$assigned, 'complete'=> $complete));
		if($value === false){
			return json_encode(array('success'=>false,'error'=>'failed to create'));
		}
		else{
			$value['success']=true;
			return json_encode($value);
		}
	}
	
	private function update_message_status($id ,$db_id, $assigned, $complete){
		$value = $this->workflow_model->update_for_message($id, array('assigned_to'=>$assigned, 'complete'=> $complete), $db_id);
		if($value === false){
			return json_encode(array('success'=>false,'error'=>'failed to update'));
		}
		else{
			$value['success']=true;
			return json_encode($value);
		}
	}
	private function check_dist_list_before_sending($addresses) {
		//check for distribution lists
		$dist_addresses = '';
		$i = 0;
		foreach($addresses as $address) {
			$this->load->model('public_distribution_list_model','pubdistlist');
			$this->load->model('private_distribution_list_model','privdistlist');
			if(!empty($address) && $this->pubdistlist->formatted_like_an_alias($address)) {
				$pub_list_result = $this->pubdistlist->find(array('id'=>$this->pubdistlist->id_from_alias($address)));
				if(count($pub_list_result) === 1) { 
					foreach($pub_list_result as $result) {
						$dist_addresses .= rtrim($result['addresses'],';');
					}
					unset($addresses[$i]);
				}
			}
			else if(!empty($address) && $this->privdistlist->formatted_like_an_alias($address)) {
				$priv_list_result = $this->privdistlist->find(array('id'=>$this->privdistlist->id_from_alias($address)));
				if(count($priv_list_result) === 1) { 
					$dist_addresses .= rtrim($priv_list_result[0]['addresses'],';');
					unset($addresses[$i]);
				}
			}
			$i++;
		}
		$addresses = array_merge($addresses,explode(';',$dist_addresses));
		return array_values(array_filter($addresses,'strlen'));
	}
	
    /* Gets form data from feedback modal panel when it is submitted and saves it to the database
     */
    private function feedback() {
        $this->load->database();
        
        $type = $this->input->post("feedback_type",TRUE);
        if($type == "feedback") { $feedback_type = "General Feedback"; }
        else if($type == "issue") { $feedback_type = "Issue Report"; }
        $comments = $this->input->post("feedback_comments",TRUE);
        $this->load->library("form_validation");
        $this->form_validation->set_rules("feedback_comments","Feedback","max_length[4000]");
		if($this->form_validation->run() === FALSE){			
			show_error("Feedback comments is longer then 4000 characters",400);
		}
        $get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
        if($get_actor_id && $get_actor_id->num_rows() == 1) {
            $row = $get_actor_id->row_array();
            $actor_id = $row["user_id"];
            $feedback = $this->db->query("INSERT INTO feedback (user_id,feedback_type,feedback_comments,feedback_datetime) VALUES (" 
										. $this->db->escape($actor_id) . "," . $this->db->escape($feedback_type) . "," 
										. $this->db->escape($comments) . "," . $this->db->escape(date('U')) . ")");
            if(!$feedback) { show_error('Failed to submit feedback due to internal error.',500); }
        }
        else { show_error('Failed to submit feedback due to internal error.',500); }
    }
	
	private function get_user_timezone() {
		$this->load->database();
		$this->load->library('locale');
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_name='.$this->db->escape($this->session->userdata('username')));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			return $this->locale->get_timezone_from_id($locale['timezone']);
		}
		return FALSE;
	}
    
    private function imap_connect() {
        $this->load->library("encrypt");
        $pconfig['login'] = $this->session->userdata("username");
        $pconfig['pass'] =  $this->encrypt->decode($this->session->userdata("ep"));
        $pconfig['host'] = IMAP_HOSTNAME;
        $pconfig['port'] = IMAP_PORT;
        $pconfig['service_flags'] = IMAP_SERVICEFLAGS;
        if(isset($_SESSION['mailbox'])) {
            $pconfig['mailbox'] = $_SESSION['mailbox'];
        }
        $this->load->library("peeker",$pconfig);            
    }  
	
	private function get_group_members($group_name){
		$dn = LDAP_GROUPS_DN;
		$members  = array();
		//get group information from ldap
		if($this->ldap->connected()) {
			$ldap_result = $this->ldap->search(NULL,NULL,array('cn','ou','description','member'),'(&(ObjectClass=groupofNames)(ou=' . $group_name . '))',$dn);
			if(count($ldap_result) > 0) {
				$data['cn'] = $ldap_result[0]['cn'];
				$data['description'] = isset($ldap_result[0]['description']) ? $ldap_result[0]['description'] : '' ;
				//get group member info from ldap
				if(is_array($ldap_result[0]['member'])) {
					foreach($ldap_result[0]['member'] as $member) {
						$username = str_replace('uid=','',$member);
						$username = str_replace(','.LDAP_ACCOUNTS_DN,'',$username);
						//if($this->user_model->logged_in_user('user_name') !== $username){//remove own username
							//check that user value corresponds to valid user
							$get_user = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($username));
							if($get_user) {
								if($get_user->num_rows() == 1) {
									$user_result = $this->ldap->search($username,1,array('cn','displayname'));
									$get_user = $get_user->result();
									if(count($user_result) > 0) {
										$member = array('cn' => $user_result[0]['cn'], 'name' => $user_result[0]['displayname'], 'username' => $username, 'id'=>$get_user[0]->user_id);
									}
									else { $member = array('name' => $username, 'username' => $username,'id'=>$get_user[0]->user_id); }
									array_push($members ,$member);
								}
							}
						//}
					}
				}
			}
		}	
		return $members;
	}
	
	public function search_group_members($search_term = NULL) {
		$group_name = $this->session->userdata('mailbox_group');
		$members = $this->get_group_members($group_name);
		$search_term = strtolower(rawurldecode($search_term));
		if(!is_null($search_term)) { 
			foreach($members as $index => $member) {
				if(!string_begins_with($search_term,strtolower($member['name'])) && !string_begins_with($search_term,strtolower($member['cn']))) {
					unset($members[$index]);
				}
			}
			$members = array_values($members);
		}
		//only echo if the request comes from AJAX
		//if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
			echo json_encode($members);
		//}
	}
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */